/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.websocket;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class DateJsonDeserializer
implements JsonDeserializer {
    private final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZ", "MMM d, yyyy h:mm:ss a", "MMM dd, yyyy HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS"};

    public Date deserialize(JsonElement jsonElement, Type typeOF, JsonDeserializationContext context) throws JsonParseException {
        for (String format : this.DATE_FORMATS) {
            try {
                return new SimpleDateFormat(format, Locale.US).parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
            }
        }
        throw new JsonParseException("Unparsable date: \"" + jsonElement.getAsString() + "\". Supported formats: " + Arrays.toString(this.DATE_FORMATS));
    }
}

