/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.websocket;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.submarine.server.workbench.websocket.ConnectionManager;
import org.apache.submarine.server.workbench.websocket.DateJsonDeserializer;
import org.apache.submarine.server.workbench.websocket.Message;
import org.apache.submarine.server.workbench.websocket.NotebookSocket;
import org.apache.submarine.server.workbench.websocket.NotebookSocketListener;
import org.apache.submarine.server.workbench.websocket.NotebookWebSocketCreator;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class NotebookServer
extends WebSocketServlet
implements NotebookSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookServer.class);
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new DateJsonDeserializer()).setPrettyPrinting().create();
    private static AtomicReference<NotebookServer> self = new AtomicReference();
    private ConnectionManager connectionManager;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    public NotebookServer() {
        this.connectionManager = new ConnectionManager();
        self.set(this);
        LOG.info("NotebookServer instantiated: {}", (Object)this);
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new NotebookWebSocketCreator(this));
    }

    @Override
    public void onOpen(NotebookSocket conn) {
        LOG.info("New connection from {}", (Object)conn);
        this.connectionManager.addConnection(conn);
    }

    @Override
    public void onMessage(NotebookSocket conn, String msg) {
        try {
            LOG.info("Got Message: " + msg);
            if (StringUtils.isEmpty((String)conn.getUser())) {
                this.connectionManager.addUserConnection("FakeUser1", conn);
            }
        }
        catch (Exception e) {
            LOG.error("Can't handle message: " + msg, (Throwable)e);
            try {
                conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", e.getMessage())));
            }
            catch (IOException iox) {
                LOG.error("Fail to send error info", (Throwable)iox);
            }
        }
    }

    @Override
    public void onClose(NotebookSocket conn, int code, String reason) {
        LOG.info("Closed connection to {} ({}) {}", new Object[]{conn, code, reason});
        this.connectionManager.removeConnection(conn);
        this.connectionManager.removeUserConnection(conn.getUser(), conn);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected Message deserializeMessage(String msg) {
        return (Message)gson.fromJson(msg, Message.class);
    }

    protected String serializeMessage(Message m) {
        return gson.toJson((Object)m);
    }

    public void broadcast(Message m) {
        this.connectionManager.broadcast(m);
    }

    @ManagedAttribute
    public Set<String> getConnectedUsers() {
        return this.connectionManager.getConnectedUsers();
    }

    @ManagedOperation
    public void sendMessage(String message) {
        Message m = new Message(Message.OP.NOTICE);
        m.data.put("notice", message);
        this.connectionManager.broadcast(m);
    }

    protected static enum JobManagerServiceType {
        JOB_MANAGER_PAGE("JOB_MANAGER_PAGE");

        private String serviceTypeKey;

        private JobManagerServiceType(String serviceType) {
            this.serviceTypeKey = serviceType;
        }

        String getKey() {
            return this.serviceTypeKey;
        }
    }
}

