/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.response;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang.StringUtils;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.Dict;
import org.apache.submarine.server.workbench.database.entity.SysDictItem;
import org.apache.submarine.server.workbench.database.service.SysDictItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(DictAnnotation.class);
    public static final String DICT_SUFFIX = "@dict";
    private Object object = null;
    private BeanMap beanMap = null;

    public DictAnnotation(Map propertyMap) {
        this.object = this.generateBean(propertyMap);
        this.beanMap = BeanMap.create((Object)this.object);
    }

    private Object generateBean(Map mapProperty) {
        BeanGenerator generator = new BeanGenerator();
        Set keySet = mapProperty.keySet();
        for (String key : keySet) {
            generator.addProperty(key, (Class)mapProperty.get(key));
        }
        return generator.create();
    }

    public void setValue(Object property, Object value) {
        this.beanMap.put(property, value);
    }

    public Object getObject() {
        return this.object;
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    private static Object mergeDictText(Object object, Map<String, List<SysDictItem>> mapDictItems) throws Exception {
        HashMap<String, Object> mapFieldValues = new HashMap<String, Object>();
        HashMap mapFieldAndType = new HashMap();
        Class<?> objectClass = object.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(objectClass);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        block0: for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            if (null == readMethod) {
                throw new Exception("Can not found " + propertyName + " ReadMethod(), All fields in " + objectClass.getName() + " need add set and set methods.");
            }
            Object result = readMethod.invoke(object, new Object[0]);
            mapFieldValues.put(propertyName, result);
            mapFieldAndType.put(propertyName, descriptor.getPropertyType());
            if (!mapDictItems.containsKey(propertyName)) continue;
            mapFieldAndType.put(propertyName + DICT_SUFFIX, String.class);
            List<SysDictItem> dictItems = mapDictItems.get(propertyName);
            for (SysDictItem dictItem : dictItems) {
                if (!StringUtils.equals((String)String.valueOf(result), (String)dictItem.getItemCode())) continue;
                mapFieldValues.put(propertyName + DICT_SUFFIX, dictItem.getItemName());
                continue block0;
            }
        }
        DictAnnotation bean = new DictAnnotation(mapFieldAndType);
        Set keys = mapFieldAndType.keySet();
        for (String key : keys) {
            bean.setValue(key, mapFieldValues.get(key));
        }
        Object newObj = bean.getObject();
        return newObj;
    }

    public static boolean parseDictAnnotation(Object result) throws Exception {
        ArrayList<Object> dicts = new ArrayList<Object>();
        if (result instanceof JsonResponse.ListResult) {
            JsonResponse.ListResult listResult = (JsonResponse.ListResult)result;
            if (listResult.getTotal() == 0L) {
                return false;
            }
            HashMap<String, List<SysDictItem>> mapDictItems = new HashMap<String, List<SysDictItem>>();
            SysDictItemService sysDictItemService = new SysDictItemService();
            Object object = listResult.getRecords().get(0);
            HashMap dictLib = new HashMap();
            for (Field field : DictAnnotation.getAllFields(object)) {
                String code;
                List<SysDictItem> dictItems;
                if (field.getAnnotation(Dict.class) == null || (dictItems = sysDictItemService.queryDictByCode(code = field.getAnnotation(Dict.class).Code())).size() <= 0) continue;
                mapDictItems.put(field.getName(), dictItems);
            }
            if (mapDictItems.size() == 0) {
                return false;
            }
            for (Object record : listResult.getRecords()) {
                Object newObj = DictAnnotation.mergeDictText(record, mapDictItems);
                dicts.add(newObj);
            }
            listResult.setRecords(dicts);
            return true;
        }
        LOG.warn("Unsupported parse {} Dict Annotation!", result.getClass());
        return false;
    }
}

