/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisUtil.class);
    private static SqlSessionFactory sqlSessionFactory;

    public static SqlSession getSqlSession() {
        return sqlSessionFactory.openSession();
    }

    private static void checkCalledByTestMethod() {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement element : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().endsWith("Test")) continue;
            MyBatisUtil.usingTestDatabase();
            return;
        }
    }

    private static void usingTestDatabase() {
        LOG.info("Run the test unit using the test database");
        SubmarineConfiguration conf = SubmarineConfiguration.getInstance();
        conf.setJdbcUrl("jdbc:mysql://127.0.0.1:3306/submarine_test?useUnicode=true&amp;characterEncoding=UTF-8&amp;autoReconnect=true&amp;failOverReadOnly=false&amp;zeroDateTimeBehavior=convertToNull&amp;useSSL=false");
        conf.setJdbcUserName("submarine_test");
        conf.setJdbcPassword("password_test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Reader reader = null;
        try {
            try {
                reader = Resources.getResourceAsReader((String)"mybatis-config.xml");
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            MyBatisUtil.checkCalledByTestMethod();
            SubmarineConfiguration conf = SubmarineConfiguration.getInstance();
            String jdbcClassName = conf.getJdbcDriverClassName();
            String jdbcUrl = conf.getJdbcUrl();
            String jdbcUserName = conf.getJdbcUserName();
            String jdbcPassword = conf.getJdbcPassword();
            LOG.info("MyBatisUtil -> jdbcClassName: {}, jdbcUrl: {}, jdbcUserName: {}, jdbcPassword: {}", new Object[]{jdbcClassName, jdbcUrl, jdbcUserName, jdbcPassword});
            Properties props = new Properties();
            props.setProperty("jdbc.driverClassName", jdbcClassName);
            props.setProperty("jdbc.url", jdbcUrl);
            props.setProperty("jdbc.username", jdbcUserName);
            props.setProperty("jdbc.password", jdbcPassword);
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader, props);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

