/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.submarine.server.workbench.database.entity.SysDept;
import org.apache.submarine.server.workbench.database.entity.SysDeptSelect;
import org.apache.submarine.server.workbench.database.entity.SysDeptTree;

public class DepartmentUtil {
    public static void disableTagetDeptCode(List<SysDeptSelect> sysDeptSelects, String deptCode) {
        if (sysDeptSelects == null) {
            return;
        }
        for (SysDeptSelect deptSelect : sysDeptSelects) {
            if (deptSelect.getKey().equalsIgnoreCase(deptCode)) {
                deptSelect.setDisabled(true);
            }
            DepartmentUtil.disableTagetDeptCode(deptSelect.getChildren(), deptCode);
        }
    }

    public static List<SysDeptTree> wrapDeptListToTree(List<SysDept> sysDeptList, List<SysDeptSelect> sysDeptSelects) {
        sysDeptSelects.clear();
        ArrayList<SysDeptTree> records = new ArrayList<SysDeptTree>();
        for (int i = 0; i < sysDeptList.size(); ++i) {
            SysDept dept = sysDeptList.get(i);
            records.add(new SysDeptTree(dept));
        }
        List<SysDeptTree> sysOrgTreeList = DepartmentUtil.findChildren(records, sysDeptSelects);
        DepartmentUtil.setEmptyChildrenAsNull(sysOrgTreeList);
        return sysOrgTreeList;
    }

    public static long getDeptTreeSize(List<SysDeptTree> sysDeptTreeList) {
        if (sysDeptTreeList == null) {
            return 0L;
        }
        long size = 0L;
        for (SysDeptTree sysDeptTree : sysDeptTreeList) {
            size += 1L + DepartmentUtil.getDeptTreeSize(sysDeptTree.getChildren());
        }
        return size;
    }

    private static List<SysDeptTree> findChildren(List<SysDeptTree> sysDeptList, List<SysDeptSelect> sysDeptSelects) {
        ArrayList<SysDeptTree> treeList = new ArrayList<SysDeptTree>();
        for (int i = 0; i < sysDeptList.size(); ++i) {
            SysDeptTree branch = sysDeptList.get(i);
            if (!DepartmentUtil.isEmpty(branch.getParentCode())) continue;
            treeList.add(branch);
            SysDeptSelect departIdModel = new SysDeptSelect().convert(branch);
            sysDeptSelects.add(departIdModel);
        }
        DepartmentUtil.getGrandChildren(treeList, sysDeptList, sysDeptSelects);
        return treeList;
    }

    private static void getGrandChildren(List<SysDeptTree> treeList, List<SysDeptTree> recordList, List<SysDeptSelect> sysDeptSelects) {
        for (int i = 0; i < treeList.size(); ++i) {
            SysDeptTree model = treeList.get(i);
            SysDeptSelect idModel = sysDeptSelects.get(i);
            for (int i1 = 0; i1 < recordList.size(); ++i1) {
                SysDeptTree m = recordList.get(i1);
                if (m.getParentCode() == null || !m.getParentCode().equals(model.getDeptCode())) continue;
                model.getChildren().add(m);
                SysDeptSelect dim = new SysDeptSelect().convert(m);
                idModel.getChildren().add(dim);
            }
            DepartmentUtil.getGrandChildren(treeList.get(i).getChildren(), recordList, sysDeptSelects.get(i).getChildren());
        }
    }

    private static void setEmptyChildrenAsNull(List<SysDeptTree> treeList) {
        for (int i = 0; i < treeList.size(); ++i) {
            SysDeptTree model = treeList.get(i);
            if (model.getChildren().size() == 0) {
                model.setChildren(null);
                continue;
            }
            DepartmentUtil.setEmptyChildrenAsNull(model.getChildren());
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object)) {
            return true;
        }
        return "null".equals(object);
    }
}

