/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.SysUser;
import org.apache.submarine.server.workbench.database.mappers.SysUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/auth")
@Produces(value={"application/json"})
@Singleton
public class LoginRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRestApi.class);
    private static final Gson gson = new Gson();

    @Inject
    public LoginRestApi() {
    }

    @POST
    @Path(value="/login")
    @SubmarineApi
    public Response login(String loginParams) {
        HashMap mapParams = (HashMap)gson.fromJson(loginParams, new TypeToken<HashMap<String, String>>(){}.getType());
        SysUser sysUser = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper sysUserMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            sysUser = sysUserMapper.login(mapParams);
            if (sysUser != null) {
                sysUser.setToken("mock_token");
            } else {
                LOG.info("User Not Found. Please try again");
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(sysUser).build();
    }

    @POST
    @Path(value="/2step-code")
    @SubmarineApi
    public Response step() {
        String data = "{stepCode:1}";
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(data).build();
    }

    @POST
    @Path(value="/logout")
    @SubmarineApi
    public Response logout() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(true).build();
    }
}

