/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.rest;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.workbench.database.entity.Project;
import org.apache.submarine.server.workbench.database.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/project")
@Produces(value={"application/json"})
@Singleton
public class ProjectRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectRestApi.class);
    private ProjectService projectService = new ProjectService();

    @Inject
    public ProjectRestApi() {
    }

    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response list(@QueryParam(value="userName") String userName, @QueryParam(value="column") String column, @QueryParam(value="order") String order, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        LOG.info("ProjectRestApi.list() owner:{}, pageNo:{}, pageSize:{}", new Object[]{userName, pageNo, pageSize});
        List<Object> projectList = new ArrayList();
        try {
            projectList = this.projectService.queryPageList(userName, column, order, pageNo, pageSize);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        PageInfo page = new PageInfo(projectList);
        JsonResponse.ListResult listResult = new JsonResponse.ListResult(projectList, page.getTotal());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }

    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response add(Project project) {
        LOG.info("add project:{}", (Object)project.toString());
        try {
            this.projectService.add(project);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Save project failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Save project successfully!").result(project).success(true).build();
    }

    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response edit(Project project) {
        LOG.info("edit project:{}", (Object)project.toString());
        try {
            this.projectService.updateByPrimaryKeySelective(project);
        }
        catch (Exception e) {
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Update project failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Update project successfully!").success(true).build();
    }

    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response delete(@QueryParam(value="id") String id) {
        LOG.info("delete project:{}", (Object)id);
        try {
            this.projectService.delete(id);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Delete project failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Delete project successfully!").success(true).build();
    }
}

