/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.websocket;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.submarine.server.workbench.websocket.DateJsonDeserializer;
import org.apache.submarine.server.workbench.websocket.Message;
import org.apache.submarine.server.workbench.websocket.NotebookSocket;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManager.class);
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new DateJsonDeserializer()).setPrettyPrinting().create();
    final Queue<NotebookSocket> connectedSockets = new ConcurrentLinkedQueue<NotebookSocket>();
    final Map<String, Queue<NotebookSocket>> userSocketMap = new ConcurrentHashMap<String, Queue<NotebookSocket>>();

    public void addConnection(NotebookSocket conn) {
        this.connectedSockets.add(conn);
    }

    public void removeConnection(NotebookSocket conn) {
        this.connectedSockets.remove((Object)conn);
    }

    public void addUserConnection(String user, NotebookSocket conn) {
        LOG.info("Add user connection {} for user: {}", (Object)conn, (Object)user);
        conn.setUser(user);
        if (this.userSocketMap.containsKey(user)) {
            this.userSocketMap.get(user).add(conn);
        } else {
            ConcurrentLinkedQueue<NotebookSocket> socketQueue = new ConcurrentLinkedQueue<NotebookSocket>();
            socketQueue.add(conn);
            this.userSocketMap.put(user, socketQueue);
        }
    }

    public void removeUserConnection(String user, NotebookSocket conn) {
        LOG.info("Remove user connection {} for user: {}", (Object)conn, (Object)user);
        if (this.userSocketMap.containsKey(user)) {
            this.userSocketMap.get(user).remove((Object)conn);
        } else {
            LOG.warn("Closing connection that is absent in user connections");
        }
    }

    protected String serializeMessage(Message m) {
        return gson.toJson((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Message m) {
        Queue<NotebookSocket> queue = this.connectedSockets;
        synchronized (queue) {
            for (NotebookSocket ns : this.connectedSockets) {
                try {
                    ns.send(this.serializeMessage(m));
                }
                catch (IOException | WebSocketException e) {
                    LOG.error("Send error: " + m, e);
                }
            }
        }
    }

    public Set<String> getConnectedUsers() {
        HashSet connectedUsers = Sets.newHashSet();
        for (NotebookSocket notebookSocket : this.connectedSockets) {
            connectedUsers.add(notebookSocket.getUser());
        }
        return connectedUsers;
    }
}

