/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server;

import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class Bootstrap
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        OpenAPI oas = new OpenAPI();
        Info info = new Info().title("Submarine API").description("The Submarine REST API allows you to access Submarine resources such as, \nexperiments, environments and notebooks. The \nAPI is hosted under the /v1 path on the Submarine server. For example, \nto list experiments on a server hosted at http://localhost:8080, access\nhttp://localhost:8080/api/v1/experiment/").termsOfService("http://swagger.io/terms/").contact(new Contact().email("dev@submarine.apache.org")).version("0.7.0").license(new License().name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0.html"));
        oas.info(info);
        ArrayList<Server> servers = new ArrayList<Server>();
        servers.add(new Server().url("/api"));
        oas.servers(servers);
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(oas).resourcePackages(Stream.of("org.apache.submarine.server.rest").collect(Collectors.toSet())).resourceClasses(Stream.of("org.apache.submarine.server.rest.NotebookRestApi", "org.apache.submarine.server.rest.ExperimentRestApi", "org.apache.submarine.server.rest.EnvironmentRestApi", "org.apache.submarine.server.rest.ServeRestApi").collect(Collectors.toSet()));
        try {
            new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)oasConfig).buildContext(true);
        }
        catch (OpenApiConfigurationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

