/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.PropertyConfigurator;
import org.apache.submarine.commons.cluster.ClusterServer;
import org.apache.submarine.commons.utils.SubmarineConfVars;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.server.database.utils.HibernateUtil;
import org.apache.submarine.server.rest.provider.YamlEntityProvider;
import org.apache.submarine.server.workbench.websocket.NotebookServer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineServer
extends ResourceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SubmarineServer.class);
    private static final long SERVERTIMESTAMP = System.currentTimeMillis();
    public static Server jettyWebServer;
    public static ServiceLocator sharedServiceLocator;
    private static WebAppContext webApp;
    private static final SubmarineConfiguration conf;

    public static long getServerTimeStamp() {
        return SERVERTIMESTAMP;
    }

    public static void main(String[] args) throws InterruptedException {
        PropertyConfigurator.configure((URL)ClassLoader.getSystemResource("log4j.properties"));
        LOG.info("Submarine server Host: " + conf.getServerAddress());
        if (!conf.useSsl()) {
            LOG.info("Submarine server Port: " + conf.getServerPort());
        } else {
            LOG.info("Submarine server SSL Port: " + conf.getServerSslPort());
        }
        jettyWebServer = SubmarineServer.setupJettyServer(conf);
        HandlerList handlers = new HandlerList();
        webApp = SubmarineServer.setupWebAppContext(handlers, conf);
        jettyWebServer.setHandler((Handler)handlers);
        sharedServiceLocator = ServiceLocatorFactory.getInstance().create("shared-locator");
        ServiceLocatorUtilities.enableImmediateScope((ServiceLocator)sharedServiceLocator);
        ServiceLocatorUtilities.bind((ServiceLocator)sharedServiceLocator, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                this.bindAsContract(NotebookServer.class).to(WebSocketServlet.class).in(Singleton.class);
            }
        }});
        SubmarineServer.setupRestApiContextHandler(webApp, conf);
        SubmarineServer.setupNotebookServer(webApp, conf, sharedServiceLocator);
        SubmarineServer.startServer();
    }

    @Inject
    public SubmarineServer() {
        this.packages(new String[]{"org.apache.submarine.server.workbench.rest", "org.apache.submarine.server.rest"});
        this.register(YamlEntityProvider.class);
    }

    private static void startServer() throws InterruptedException {
        LOG.info("Starting submarine server");
        try {
            jettyWebServer.start();
        }
        catch (Exception e) {
            LOG.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, submarine server started");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Shutting down Submarine Server ... ");
            try {
                HibernateUtil.close();
                jettyWebServer.stop();
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted exception:", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error while stopping servlet container", (Throwable)e);
            }
            LOG.info("Bye");
        }));
        jettyWebServer.join();
    }

    private static void setupRestApiContextHandler(WebAppContext webapp, SubmarineConfiguration conf) {
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer());
        servletHolder.setInitParameter("javax.ws.rs.Application", SubmarineServer.class.getName());
        servletHolder.setName("rest");
        servletHolder.setForcedPath("rest");
        webapp.setSessionHandler(new SessionHandler());
        webapp.addServlet(servletHolder, "/api/*");
    }

    private static WebAppContext setupWebAppContext(HandlerList handlers, SubmarineConfiguration conf) {
        WebAppContext webApp = new WebAppContext();
        webApp.setContextPath("/");
        File warPath = new File(conf.getString(SubmarineConfVars.ConfVars.WORKBENCH_WEB_WAR));
        LOG.info("workbench web war file path is {}.", (Object)conf.getString(SubmarineConfVars.ConfVars.WORKBENCH_WEB_WAR));
        if (warPath.isDirectory()) {
            webApp.setResourceBase(warPath.getPath());
            webApp.setParentLoaderPriority(true);
        } else {
            webApp.setWar(warPath.getAbsolutePath());
            File warTempDirectory = new File("webapps");
            warTempDirectory.mkdir();
            webApp.setTempDirectory(warTempDirectory);
        }
        webApp.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/");
        webApp.addServlet(new ServletHolder(RefreshServlet.class), "/user/*");
        webApp.addServlet(new ServletHolder(RefreshServlet.class), "/workbench/*");
        handlers.setHandlers(new Handler[]{webApp});
        return webApp;
    }

    private static Server setupJettyServer(SubmarineConfiguration conf) {
        ServerConnector connector;
        QueuedThreadPool threadPool = new QueuedThreadPool(conf.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_JETTY_THREAD_POOL_MAX), conf.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_JETTY_THREAD_POOL_MIN), conf.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_JETTY_THREAD_POOL_TIMEOUT));
        Server server = new Server((ThreadPool)threadPool);
        if (conf.useSsl()) {
            LOG.debug("Enabling SSL for submarine Server on port " + conf.getServerSslPort());
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(conf.getServerSslPort());
            httpConfig.setOutputBufferSize(32768);
            httpConfig.setResponseHeaderSize(8192);
            httpConfig.setSendServerVersion(true);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
            connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(SubmarineServer.getSslContextFactory(conf), HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        } else {
            connector = new ServerConnector(server);
        }
        SubmarineServer.configureRequestHeaderSize(conf, connector);
        int timeout = 30000;
        connector.setIdleTimeout((long)timeout);
        connector.setHost(conf.getServerAddress());
        if (conf.useSsl()) {
            connector.setPort(conf.getServerSslPort());
        } else {
            connector.setPort(conf.getServerPort());
        }
        server.addConnector((Connector)connector);
        return server;
    }

    private static void setupNotebookServer(WebAppContext webapp, SubmarineConfiguration conf, ServiceLocator serviceLocator) {
        String maxTextMessageSize = conf.getWebsocketMaxTextMessageSize();
        ServletHolder servletHolder = new ServletHolder((Servlet)serviceLocator.getService(NotebookServer.class, new Annotation[0]));
        servletHolder.setInitParameter("maxTextMessageSize", maxTextMessageSize);
        ServletContextHandler context = new ServletContextHandler(1);
        webapp.addServlet(servletHolder, "/ws/*");
    }

    private static void setupClusterServer() {
        if (conf.isClusterMode()) {
            ClusterServer clusterServer = ClusterServer.getInstance();
            clusterServer.start();
        }
    }

    private static SslContextFactory getSslContextFactory(SubmarineConfiguration conf) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(conf.getKeyStorePath());
        sslContextFactory.setKeyStoreType(conf.getKeyStoreType());
        sslContextFactory.setKeyStorePassword(conf.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(conf.getKeyManagerPassword());
        if (conf.useClientAuth()) {
            sslContextFactory.setNeedClientAuth(conf.useClientAuth());
            sslContextFactory.setTrustStorePath(conf.getTrustStorePath());
            sslContextFactory.setTrustStoreType(conf.getTrustStoreType());
            sslContextFactory.setTrustStorePassword(conf.getTrustStorePassword());
        }
        return sslContextFactory;
    }

    private static void configureRequestHeaderSize(SubmarineConfiguration conf, ServerConnector connector) {
        HttpConnectionFactory cf = (HttpConnectionFactory)connector.getConnectionFactory(HttpVersion.HTTP_1_1.toString());
        int requestHeaderSize = conf.getJettyRequestHeaderSize();
        cf.getHttpConfiguration().setRequestHeaderSize(requestHeaderSize);
    }

    static {
        conf = SubmarineConfiguration.getInstance();
    }

    public static class RefreshServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            response.encodeRedirectURL("/");
            response.setStatus(200);
            File warPath = new File(conf.getString(SubmarineConfVars.ConfVars.WORKBENCH_WEB_WAR));
            File indexFile = null;
            if (warPath.isDirectory()) {
                indexFile = new File(warPath.getAbsolutePath() + "/index.html");
            } else {
                File warFile = webApp.getTempDirectory();
                if (!warFile.exists()) {
                    throw new ServletException("Can't found war directory!");
                }
                indexFile = new File(warFile.getAbsolutePath() + "/webapp/index.html");
            }
            if (!indexFile.isFile() || !indexFile.exists()) {
                throw new ServletException("Can't found index html!");
            }
            StringBuilder sbIndexBuf = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(indexFile), "GBK");
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    sbIndexBuf.append(lineTxt);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            response.getWriter().print(sbIndexBuf.toString());
        }
    }
}

