/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.submarine.commons.utils.SubmarineConfVars;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.server.api.Submitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitterManager {
    private static final Logger LOG = LoggerFactory.getLogger(SubmitterManager.class);
    private static final SubmitterManager INSTANCE = new SubmitterManager();
    private final Map<String, JobSubmitterConfig> SUBMITTER_CONFIG_MAP = new HashMap<String, JobSubmitterConfig>();
    private Submitter submitter;

    public static Submitter loadSubmitter() {
        return SubmitterManager.INSTANCE.submitter;
    }

    private SubmitterManager() {
        String home = System.getenv("SUBMARINE_HOME");
        LOG.info("Submarine Home: {}", (Object)home);
        this.SUBMITTER_CONFIG_MAP.put("k8s", new JobSubmitterConfig("org.apache.submarine.server.submitter.k8s.K8sSubmitter", home + "/lib/submitter/k8s/"));
        SubmarineConfiguration conf = SubmarineConfiguration.getInstance();
        String type = conf.getString(SubmarineConfVars.ConfVars.SUBMARINE_SUBMITTER);
        String clazzName = this.SUBMITTER_CONFIG_MAP.get(type).clazzName;
        String classpath = this.SUBMITTER_CONFIG_MAP.get(type).classpath;
        try {
            URLClassLoader classLoader = new URLClassLoader(this.constructUrlsFromClasspath(classpath));
            Class<?> clazz = Class.forName(clazzName, true, classLoader);
            Class<Submitter> sClass = clazz.asSubclass(Submitter.class);
            Constructor<Submitter> method = sClass.getDeclaredConstructor(new Class[0]);
            this.submitter = method.newInstance(new Object[0]);
            this.submitter.initialize(conf);
        }
        catch (Exception e) {
            LOG.error("Initialize the submitter failed. " + e.getMessage(), (Throwable)e);
        }
    }

    private URL[] constructUrlsFromClasspath(String classpath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            File file;
            if (path.endsWith("/*")) {
                path = path.substring(0, path.length() - 2);
            }
            if ((file = new File(path)).isDirectory()) {
                File[] items = file.listFiles();
                if (items == null) continue;
                for (File item : items) {
                    urls.add(item.toURI().toURL());
                }
                continue;
            }
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[0]);
    }

    private static class JobSubmitterConfig {
        private final String clazzName;
        private final String classpath;

        JobSubmitterConfig(String clazzName, String classpath) {
            this.clazzName = clazzName;
            this.classpath = classpath;
        }
    }
}

