/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.database.entity;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Date;
import org.apache.submarine.server.workbench.database.utils.CustomJsonDateDeserializer;

public abstract class BaseEntity {
    protected String id;
    protected String createBy;
    @JsonDeserialize(using=CustomJsonDateDeserializer.class)
    protected Date createTime = new Date();
    protected String updateBy;
    @JsonDeserialize(using=CustomJsonDateDeserializer.class)
    protected Date updateTime = new Date();

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    public void setId(String id) {
        this.id = id;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String userId) {
        this.createBy = userId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(String userId) {
        this.updateBy = userId;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Class<?> clazz = this.getClass();
        String fullName = clazz.getName();
        int position = fullName.lastIndexOf(".");
        String shortName = fullName.substring(position + 1);
        buffer.append(shortName);
        buffer.append(": [");
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            try {
                buffer.append(((Field)field).getName());
                buffer.append("=");
                buffer.append(((Field)field).get(this));
                buffer.append(", ");
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        buffer.setLength(buffer.length() - 2);
        buffer.append("]");
        return buffer.toString();
    }
}

