/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.database.utils;

import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateUtil.class);
    private static final SessionFactory sessionFactory = HibernateUtil.buildSessionFactory();

    public static void close() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
        LOG.info("Hibernate session is closed.");
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    private static SessionFactory buildSessionFactory() throws SubmarineRuntimeException {
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().configure().build();
        try {
            return new MetadataSources((ServiceRegistry)registry).buildMetadata().buildSessionFactory();
        }
        catch (Exception e) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to build session factory");
        }
    }

    private HibernateUtil() {
    }
}

