/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.environment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.SubmarineServer;
import org.apache.submarine.server.api.environment.Environment;
import org.apache.submarine.server.api.environment.EnvironmentId;
import org.apache.submarine.server.api.spec.EnvironmentSpec;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.environment.database.entity.EnvironmentEntity;
import org.apache.submarine.server.environment.database.mappers.EnvironmentMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentManager {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentManager.class);
    private static volatile EnvironmentManager manager;
    private final AtomicInteger environmentIdCounter = new AtomicInteger(0);
    private static Boolean readedDB;
    private final ConcurrentMap<String, Environment> cachedEnvironments = new ConcurrentHashMap<String, Environment>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnvironmentManager getInstance() {
        if (manager != null) return manager;
        Class<EnvironmentManager> clazz = EnvironmentManager.class;
        synchronized (EnvironmentManager.class) {
            if (manager != null) return manager;
            manager = new EnvironmentManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private EnvironmentManager() {
    }

    public Environment createEnvironment(EnvironmentSpec spec) throws SubmarineRuntimeException {
        this.checkSpec(spec);
        LOG.info("Create Environment using spec: " + spec.toString());
        return this.createOrUpdateEnvironment(spec, "c");
    }

    public Environment updateEnvironment(String name, EnvironmentSpec spec) throws SubmarineRuntimeException {
        Environment env = this.getEnvironmentDetails(name);
        if (env == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Environment not found.");
        }
        this.checkSpec(spec);
        LOG.info("Update Environment using spec: " + spec.toString());
        return this.createOrUpdateEnvironment(spec, "u");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Environment createOrUpdateEnvironment(EnvironmentSpec spec, String operation) {
        EnvironmentEntity entity = new EnvironmentEntity();
        String environmentId = this.generateEnvironmentId().toString();
        entity.setId(environmentId);
        entity.setEnvironmentName(spec.getName());
        entity.setEnvironmentSpec(new GsonBuilder().disableHtmlEscaping().create().toJson((Object)spec));
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            EnvironmentMapper environmentMapper = (EnvironmentMapper)sqlSession.getMapper(EnvironmentMapper.class);
            if (operation.equals("c")) {
                environmentMapper.insert(entity);
            } else {
                environmentMapper.update(entity);
            }
            sqlSession.commit();
            Environment environment = new Environment();
            environment.setEnvironmentId(EnvironmentId.fromString((String)environmentId));
            environment.setEnvironmentSpec(spec);
            this.cachedEnvironments.putIfAbsent(spec.getName(), environment);
            Environment environment2 = environment;
            return environment2;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process the environment spec.");
        }
    }

    private EnvironmentId generateEnvironmentId() {
        return EnvironmentId.newInstance((long)SubmarineServer.getServerTimeStamp(), (int)this.environmentIdCounter.incrementAndGet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Environment deleteEnvironment(String name) throws SubmarineRuntimeException {
        Environment env = this.getEnvironmentDetails(name);
        if (env == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Environment not found.");
        }
        LOG.info("Delete Environment for " + name);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            EnvironmentMapper environmentMapper = (EnvironmentMapper)sqlSession.getMapper(EnvironmentMapper.class);
            environmentMapper.delete(name);
            sqlSession.commit();
            this.cachedEnvironments.remove(name);
            Environment environment = env;
            return environment;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to delete the environment.");
        }
    }

    public Environment getEnvironment(String name) throws SubmarineRuntimeException {
        Environment environment = this.getEnvironmentDetails(name);
        if (environment == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Environment not found.");
        }
        return environment;
    }

    public List<Environment> listEnvironments(String status) throws SubmarineRuntimeException {
        ArrayList<Environment> environmentList = new ArrayList<Environment>(this.cachedEnvironments.values());
        if (readedDB.booleanValue()) {
            try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
                EnvironmentMapper environmentMapper = (EnvironmentMapper)sqlSession.getMapper(EnvironmentMapper.class);
                List<EnvironmentEntity> environmentEntities = environmentMapper.selectAll();
                for (EnvironmentEntity environmentEntity : environmentEntities) {
                    if (environmentEntity == null) continue;
                    Environment env = new Environment();
                    env.setEnvironmentSpec((EnvironmentSpec)new Gson().fromJson(environmentEntity.getEnvironmentSpec(), EnvironmentSpec.class));
                    env.setEnvironmentId(EnvironmentId.fromString((String)environmentEntity.getId()));
                    environmentList.add(env);
                    this.cachedEnvironments.put(env.getEnvironmentSpec().getName(), env);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to get the environment list.");
            }
        }
        readedDB = false;
        return environmentList;
    }

    private void checkSpec(EnvironmentSpec spec) throws SubmarineRuntimeException {
        if (spec == null) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Invalid environment spec.");
        }
    }

    private Environment getEnvironmentDetails(String name) throws SubmarineRuntimeException {
        Environment env = (Environment)this.cachedEnvironments.get(name);
        if (env != null) {
            return env;
        }
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            EnvironmentMapper environmentMapper = (EnvironmentMapper)sqlSession.getMapper(EnvironmentMapper.class);
            EnvironmentEntity environmentEntity = environmentMapper.select(name);
            if (environmentEntity != null) {
                env = new Environment();
                env.setEnvironmentSpec((EnvironmentSpec)new Gson().fromJson(environmentEntity.getEnvironmentSpec(), EnvironmentSpec.class));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to get the environment details.");
        }
        return env;
    }

    static {
        readedDB = true;
    }
}

