/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.experiment;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.SubmarineServer;
import org.apache.submarine.server.SubmitterManager;
import org.apache.submarine.server.api.Submitter;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.api.experiment.ExperimentId;
import org.apache.submarine.server.api.experiment.ExperimentLog;
import org.apache.submarine.server.api.experiment.MlflowInfo;
import org.apache.submarine.server.api.experiment.TensorboardInfo;
import org.apache.submarine.server.api.spec.ExperimentSpec;
import org.apache.submarine.server.experiment.database.entity.ExperimentEntity;
import org.apache.submarine.server.experiment.database.service.ExperimentService;
import org.joda.time.DateTime;
import org.mlflow.api.proto.Service;
import org.mlflow.tracking.MlflowClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentManager.class);
    private static volatile ExperimentManager manager;
    private final AtomicInteger experimentCounter = new AtomicInteger(0);
    private Optional<Service.Experiment> MlflowExperimentOptional;
    private Service.Experiment MlflowExperiment;
    private final ConcurrentMap<String, Experiment> cachedExperimentMap = new ConcurrentHashMap<String, Experiment>();
    private final Submitter submitter;
    private final ExperimentService experimentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExperimentManager getInstance() {
        if (manager != null) return manager;
        Class<ExperimentManager> clazz = ExperimentManager.class;
        synchronized (ExperimentManager.class) {
            if (manager != null) return manager;
            manager = new ExperimentManager(SubmitterManager.loadSubmitter(), new ExperimentService());
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @VisibleForTesting
    protected ExperimentManager(Submitter submitter, ExperimentService experimentService) {
        this.submitter = submitter;
        this.experimentService = experimentService;
    }

    public Experiment createExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        this.checkSpec(spec);
        ExperimentId id = this.generateExperimentId();
        String url = this.getSQLAlchemyURL();
        spec.getMeta().getEnvVars().put("JOB_ID", id.toString());
        spec.getMeta().getEnvVars().put("SUBMARINE_TRACKING_URI", url);
        spec.getMeta().getEnvVars().put("SUBMARINE_TENSORBOARD_LOG_DIR", "/logs/mylog");
        String lowerName = spec.getMeta().getName().toLowerCase();
        spec.getMeta().setName(lowerName);
        spec.getMeta().setExperimentId(id.toString());
        Experiment experiment = this.submitter.createExperiment(spec);
        experiment.setExperimentId(id);
        spec.getMeta().getEnvVars().remove("JOB_ID");
        spec.getMeta().getEnvVars().remove("SUBMARINE_TRACKING_URI");
        spec.getMeta().getEnvVars().remove("SUBMARINE_TENSORBOARD_LOG_DIR");
        experiment.setSpec(spec);
        ExperimentEntity entity = this.buildEntityFromExperiment(experiment);
        entity.setExperimentStatus(Experiment.Status.STATUS_ACCEPTED.toString());
        this.experimentService.insert(entity);
        return experiment;
    }

    public Experiment getExperiment(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        ExperimentEntity entity = this.experimentService.select(id);
        Experiment experiment = this.buildExperimentFromEntity(entity);
        return experiment;
    }

    public List<Experiment> listExperimentsByStatus(String status) throws SubmarineRuntimeException {
        ArrayList<Experiment> experimentList = new ArrayList<Experiment>();
        List<ExperimentEntity> entities = this.experimentService.selectAll();
        for (ExperimentEntity entity : entities) {
            Experiment experiment = this.buildExperimentFromEntity(entity);
            experimentList.add(experiment);
        }
        LOG.info("List experiment: {}", (Object)experimentList.size());
        return experimentList;
    }

    public List<Experiment> listExperimentsByTag(String searchTag) throws SubmarineRuntimeException {
        ArrayList<Experiment> experimentList = new ArrayList<Experiment>();
        List<ExperimentEntity> entities = this.experimentService.selectAll();
        block0: for (ExperimentEntity entity : entities) {
            Experiment experiment = this.buildExperimentFromEntity(entity);
            if (searchTag == null) {
                experimentList.add(experiment);
                continue;
            }
            for (String tag : experiment.getSpec().getMeta().getTags()) {
                if (!tag.equalsIgnoreCase(searchTag)) continue;
                experimentList.add(experiment);
                continue block0;
            }
        }
        LOG.info("List experiment: {}", (Object)experimentList.size());
        return experimentList;
    }

    public Experiment patchExperiment(String id, ExperimentSpec newSpec) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        this.checkSpec(newSpec);
        newSpec.getMeta().setExperimentId(id);
        ExperimentEntity entity = this.experimentService.select(id);
        Experiment experiment = this.buildExperimentFromEntity(entity);
        Experiment patchExperiment = this.submitter.patchExperiment(newSpec);
        experiment.setSpec(newSpec);
        entity.setExperimentSpec(new GsonBuilder().disableHtmlEscaping().create().toJson((Object)newSpec));
        this.experimentService.update(entity);
        experiment.rebuild(patchExperiment);
        return experiment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Experiment deleteExperiment(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        ExperimentEntity entity = this.experimentService.select(id);
        Experiment experiment = this.buildExperimentFromEntity(entity);
        Experiment deletedExperiment = this.submitter.deleteExperiment(experiment.getSpec());
        this.experimentService.delete(id);
        experiment.rebuild(deletedExperiment);
        MlflowClient mlflowClient = new MlflowClient("http://submarine-mlflow-service:5000");
        try {
            this.MlflowExperimentOptional = mlflowClient.getExperimentByName(id);
            this.MlflowExperiment = this.MlflowExperimentOptional.get();
            String mlflowId = this.MlflowExperiment.getExperimentId();
            mlflowClient.deleteExperiment(mlflowId);
        }
        finally {
            return experiment;
        }
    }

    public List<ExperimentLog> listExperimentLogsByStatus(String status) throws SubmarineRuntimeException {
        ArrayList<ExperimentLog> experimentLogList = new ArrayList<ExperimentLog>();
        List<ExperimentEntity> entities = this.experimentService.selectAll();
        for (ExperimentEntity entity : entities) {
            Experiment experiment = this.buildExperimentFromEntity(entity);
            if (status != null && !status.toLowerCase().equals(experiment.getStatus().toLowerCase())) continue;
            experimentLogList.add(this.submitter.getExperimentLogName(experiment.getSpec(), experiment.getSpec().getMeta().getExperimentId()));
        }
        return experimentLogList;
    }

    public ExperimentLog getExperimentLog(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        ExperimentEntity entity = this.experimentService.select(id);
        Experiment experiment = this.buildExperimentFromEntity(entity);
        return this.submitter.getExperimentLog(experiment.getSpec(), id);
    }

    public TensorboardInfo getTensorboardInfo() throws SubmarineRuntimeException {
        return this.submitter.getTensorboardInfo();
    }

    public MlflowInfo getMLflowInfo() throws SubmarineRuntimeException {
        return this.submitter.getMlflowInfo();
    }

    private void checkSpec(ExperimentSpec spec) throws SubmarineRuntimeException {
        if (spec == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid experiment spec.");
        }
    }

    private void checkExperimentId(String id) throws SubmarineRuntimeException {
        ExperimentEntity entity = this.experimentService.select(id);
        if (entity == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Not found experiment.");
        }
    }

    private String getSQLAlchemyURL() {
        SubmarineConfiguration conf = SubmarineConfiguration.getInstance();
        String jdbcUrl = conf.getJdbcUrl();
        jdbcUrl = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2, jdbcUrl.indexOf("?"));
        String jdbcUserName = conf.getJdbcUserName();
        String jdbcPassword = conf.getJdbcPassword();
        return "mysql+pymysql://" + jdbcUserName + ":" + jdbcPassword + "@" + jdbcUrl;
    }

    public ExperimentId generateExperimentId() {
        return ExperimentId.newInstance((long)SubmarineServer.getServerTimeStamp(), (int)this.experimentCounter.incrementAndGet());
    }

    private Experiment buildExperimentFromEntity(ExperimentEntity entity) {
        Experiment experiment = new Experiment();
        experiment.setExperimentId(ExperimentId.fromString((String)entity.getId()));
        experiment.setSpec((ExperimentSpec)new Gson().fromJson(entity.getExperimentSpec(), ExperimentSpec.class));
        experiment.setStatus(entity.getExperimentStatus());
        if (entity.getCreateTime() != null) {
            experiment.setCreatedTime(new DateTime((Object)entity.getCreateTime()).toString());
        } else {
            experiment.setCreatedTime(null);
        }
        if (entity.getAcceptedTime() != null) {
            experiment.setAcceptedTime(new DateTime((Object)entity.getAcceptedTime()).toString());
        } else {
            experiment.setAcceptedTime(null);
        }
        if (entity.getRunningTime() != null) {
            experiment.setRunningTime(new DateTime((Object)entity.getRunningTime()).toString());
        } else {
            experiment.setRunningTime(null);
        }
        if (entity.getFinishedTime() != null) {
            experiment.setFinishedTime(new DateTime((Object)entity.getFinishedTime()).toString());
        } else {
            experiment.setFinishedTime(null);
        }
        experiment.setUid(entity.getUid());
        return experiment;
    }

    private ExperimentEntity buildEntityFromExperiment(Experiment experiment) {
        ExperimentEntity entity = new ExperimentEntity();
        entity.setId(experiment.getSpec().getMeta().getExperimentId());
        entity.setExperimentSpec(new GsonBuilder().disableHtmlEscaping().create().toJson((Object)experiment.getSpec()));
        if (experiment.getCreatedTime() != null) {
            entity.setCreateTime(DateTime.parse((String)experiment.getCreatedTime()).toDate());
        } else {
            entity.setCreateTime(null);
        }
        if (experiment.getAcceptedTime() != null) {
            entity.setAcceptedTime(DateTime.parse((String)experiment.getAcceptedTime()).toDate());
        } else {
            entity.setAcceptedTime(null);
        }
        if (experiment.getRunningTime() != null) {
            entity.setRunningTime(DateTime.parse((String)experiment.getRunningTime()).toDate());
        } else {
            entity.setRunningTime(null);
        }
        if (experiment.getFinishedTime() != null) {
            entity.setFinishedTime(DateTime.parse((String)experiment.getFinishedTime()).toDate());
        } else {
            entity.setFinishedTime(null);
        }
        entity.setUid(experiment.getUid());
        return entity;
    }
}

