/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.experiment.database.service;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.experiment.database.entity.ExperimentEntity;
import org.apache.submarine.server.experiment.database.mappers.ExperimentMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentService {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentService.class);

    public List<ExperimentEntity> selectAll() throws SubmarineRuntimeException {
        List<ExperimentEntity> entities;
        LOG.info("Experiment selectAll");
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentMapper mapper = (ExperimentMapper)sqlSession.getMapper(ExperimentMapper.class);
            entities = mapper.selectAll();
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to get experiment entities from database");
        }
        return entities;
    }

    public ExperimentEntity select(String id) throws SubmarineRuntimeException {
        ExperimentEntity entity;
        LOG.info("Experiment select " + id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentMapper mapper = (ExperimentMapper)sqlSession.getMapper(ExperimentMapper.class);
            entity = mapper.select(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to get experiment entity from database");
        }
        return entity;
    }

    public boolean insert(ExperimentEntity experiment) throws SubmarineRuntimeException {
        LOG.info("Experiment insert");
        LOG.debug(experiment.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentMapper mapper = (ExperimentMapper)sqlSession.getMapper(ExperimentMapper.class);
            mapper.insert(experiment);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to insert experiment entity to database");
        }
        return true;
    }

    public boolean update(ExperimentEntity experiment) throws SubmarineRuntimeException {
        LOG.info("Experiment update");
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentMapper mapper = (ExperimentMapper)sqlSession.getMapper(ExperimentMapper.class);
            mapper.update(experiment);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to update experiment entity in database");
        }
        return true;
    }

    public boolean delete(String id) throws SubmarineRuntimeException {
        LOG.info("Experiment delete " + id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentMapper mapper = (ExperimentMapper)sqlSession.getMapper(ExperimentMapper.class);
            mapper.delete(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to delete experiment entity from database");
        }
        return true;
    }
}

