/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.experimenttemplate;

import com.esotericsoftware.minlog.Log;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.SubmarineServer;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.api.experiment.ExperimentId;
import org.apache.submarine.server.api.experimenttemplate.ExperimentTemplate;
import org.apache.submarine.server.api.experimenttemplate.ExperimentTemplateId;
import org.apache.submarine.server.api.experimenttemplate.ExperimentTemplateSubmit;
import org.apache.submarine.server.api.spec.ExperimentSpec;
import org.apache.submarine.server.api.spec.ExperimentTaskSpec;
import org.apache.submarine.server.api.spec.ExperimentTemplateParamSpec;
import org.apache.submarine.server.api.spec.ExperimentTemplateSpec;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.experiment.ExperimentManager;
import org.apache.submarine.server.experimenttemplate.database.entity.ExperimentTemplateEntity;
import org.apache.submarine.server.experimenttemplate.database.mappers.ExperimentTemplateMapper;
import org.apache.submarine.server.utils.gson.ExperimentIdDeserializer;
import org.apache.submarine.server.utils.gson.ExperimentIdSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentTemplateManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentTemplateManager.class);
    private static volatile ExperimentTemplateManager manager;
    private final AtomicInteger experimentTemplateIdCounter = new AtomicInteger(0);
    private static final GsonBuilder gsonBuilder;
    private static final Gson gson;
    private final ConcurrentMap<String, ExperimentTemplate> cachedExperimentTemplates = new ConcurrentHashMap<String, ExperimentTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExperimentTemplateManager getInstance() {
        if (manager != null) return manager;
        Class<ExperimentTemplateManager> clazz = ExperimentTemplateManager.class;
        synchronized (ExperimentTemplateManager.class) {
            if (manager != null) return manager;
            manager = new ExperimentTemplateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private ExperimentTemplateManager() {
    }

    public ExperimentTemplate createExperimentTemplate(ExperimentTemplateSpec spec) throws SubmarineRuntimeException {
        this.checkSpec(spec);
        LOG.info("Create ExperimentTemplate using spec: " + spec.toString());
        return this.createOrUpdateExperimentTemplate(spec, "c");
    }

    public ExperimentTemplate updateExperimentTemplate(String name, ExperimentTemplateSpec spec) throws SubmarineRuntimeException {
        ExperimentTemplate tpl = this.getExperimentTemplateDetails(name);
        if (tpl == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "ExperimentTemplate not found.");
        }
        this.checkSpec(spec);
        LOG.info("Update ExperimentTemplate using spec: " + spec.toString());
        return this.createOrUpdateExperimentTemplate(spec, "u");
    }

    private ExperimentTemplate createOrUpdateExperimentTemplate(ExperimentTemplateSpec spec, String operation) {
        ExperimentTemplate experimentTemplate;
        spec = this.addResourcesParameter(spec);
        ExperimentTemplateEntity entity = new ExperimentTemplateEntity();
        String experimentTemplateId = this.generateExperimentTemplateId().toString();
        entity.setId(experimentTemplateId);
        entity.setExperimentTemplateName(spec.getName());
        entity.setExperimentTemplateSpec(gsonBuilder.disableHtmlEscaping().create().toJson((Object)spec));
        this.parameterMapping(spec);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentTemplateMapper experimentTemplateMapper = (ExperimentTemplateMapper)sqlSession.getMapper(ExperimentTemplateMapper.class);
            if (operation.equals("c")) {
                experimentTemplateMapper.insert(entity);
            } else {
                experimentTemplateMapper.update(entity);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to insert or update the experimentTemplate spec: " + e.getMessage());
        }
        try {
            experimentTemplate = new ExperimentTemplate();
            experimentTemplate.setExperimentTemplateId(ExperimentTemplateId.fromString((String)experimentTemplateId));
            experimentTemplate.setExperimentTemplateSpec(spec);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to parse the experimentTemplate spec: " + e.getMessage());
        }
        this.cachedExperimentTemplates.put(spec.getName(), experimentTemplate);
        return experimentTemplate;
    }

    private ExperimentTemplateId generateExperimentTemplateId() {
        return ExperimentTemplateId.newInstance((long)SubmarineServer.getServerTimeStamp(), (int)this.experimentTemplateIdCounter.incrementAndGet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExperimentTemplate deleteExperimentTemplate(String name) throws SubmarineRuntimeException {
        ExperimentTemplate tpl = this.getExperimentTemplateDetails(name);
        if (tpl == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "ExperimentTemplate not found.");
        }
        LOG.info("Delete ExperimentTemplate for " + name);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentTemplateMapper experimentTemplateMapper = (ExperimentTemplateMapper)sqlSession.getMapper(ExperimentTemplateMapper.class);
            experimentTemplateMapper.delete(name);
            sqlSession.commit();
            this.cachedExperimentTemplates.remove(name);
            ExperimentTemplate experimentTemplate = tpl;
            return experimentTemplate;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to delete the experimentTemplate.");
        }
    }

    public ExperimentTemplate getExperimentTemplate(String name) throws SubmarineRuntimeException {
        ExperimentTemplate experimentTemplate = this.getExperimentTemplateDetails(name);
        if (experimentTemplate == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "ExperimentTemplate not found.");
        }
        return experimentTemplate;
    }

    public List<ExperimentTemplate> listExperimentTemplates(String status) throws SubmarineRuntimeException {
        ArrayList<ExperimentTemplate> tpls = new ArrayList<ExperimentTemplate>(this.cachedExperimentTemplates.values());
        if (tpls.size() != 0) {
            return tpls;
        }
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentTemplateMapper experimentTemplateMapper = (ExperimentTemplateMapper)sqlSession.getMapper(ExperimentTemplateMapper.class);
            List<ExperimentTemplateEntity> experimentTemplateEntities = experimentTemplateMapper.selectByKey(null);
            for (ExperimentTemplateEntity experimentTemplateEntity : experimentTemplateEntities) {
                if (experimentTemplateEntity == null) continue;
                ExperimentTemplate tpl = new ExperimentTemplate();
                tpl.setExperimentTemplateSpec((ExperimentTemplateSpec)gson.fromJson(experimentTemplateEntity.getExperimentTemplateSpec(), ExperimentTemplateSpec.class));
                tpls.add(tpl);
                this.cachedExperimentTemplates.put(tpl.getExperimentTemplateSpec().getName(), tpl);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to get the experimentTemplate details.");
        }
        return tpls;
    }

    private void checkSpec(ExperimentTemplateSpec spec) throws SubmarineRuntimeException {
        if (spec == null) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Invalid experimentTemplate spec.");
        }
    }

    private ExperimentTemplate getExperimentTemplateDetails(String name) throws SubmarineRuntimeException {
        ExperimentTemplate tpl = (ExperimentTemplate)this.cachedExperimentTemplates.get(name);
        if (tpl != null) {
            return tpl;
        }
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ExperimentTemplateMapper experimentTemplateMapper = (ExperimentTemplateMapper)sqlSession.getMapper(ExperimentTemplateMapper.class);
            ExperimentTemplateEntity experimentTemplateEntity = experimentTemplateMapper.select(name);
            if (experimentTemplateEntity != null) {
                tpl = new ExperimentTemplate();
                tpl.setExperimentTemplateSpec((ExperimentTemplateSpec)gson.fromJson(experimentTemplateEntity.getExperimentTemplateSpec(), ExperimentTemplateSpec.class));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to get the experimentTemplate details.");
        }
        return tpl;
    }

    public Experiment submitExperimentTemplate(ExperimentTemplateSubmit submittedParam) throws SubmarineRuntimeException {
        if (submittedParam == null) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Invalid ExperimentTemplateSubmit spec.");
        }
        ExperimentTemplate experimentTemplate = this.getExperimentTemplate(submittedParam.getName());
        Map params = submittedParam.getParams();
        for (ExperimentTemplateParamSpec paramSpec : experimentTemplate.getExperimentTemplateSpec().getExperimentTemplateParamSpec()) {
            String value = (String)params.get(paramSpec.getName());
            if (value == null) continue;
            paramSpec.setValue(value);
        }
        ExperimentTemplateSpec spec = experimentTemplate.getExperimentTemplateSpec();
        ExperimentSpec experimentSpec = this.parameterMapping(spec, params);
        return ExperimentManager.getInstance().createExperiment(experimentSpec);
    }

    private ExperimentTemplateSpec addResourcesParameter(ExperimentTemplateSpec tplSpec) {
        for (Map.Entry entrySet : tplSpec.getExperimentSpec().getSpec().entrySet()) {
            ExperimentTaskSpec taskSpec = (ExperimentTaskSpec)entrySet.getValue();
            taskSpec.setResources(taskSpec.getResources());
            ExperimentTemplateParamSpec parm1 = new ExperimentTemplateParamSpec();
            parm1.setName(String.format("spec.%s.replicas", entrySet.getKey()));
            parm1.setValue(taskSpec.getReplicas() == null ? "1" : taskSpec.getReplicas().toString());
            parm1.setRequired("false");
            parm1.setDescription("");
            tplSpec.getExperimentTemplateParamSpec().add(parm1);
            ExperimentTemplateParamSpec parm2 = new ExperimentTemplateParamSpec();
            parm2.setName(String.format("spec.%s.resourceMap.cpu", entrySet.getKey()));
            parm2.setValue(taskSpec.getCpu() == null ? "1" : taskSpec.getCpu());
            parm2.setRequired("false");
            parm2.setDescription("");
            tplSpec.getExperimentTemplateParamSpec().add(parm2);
            ExperimentTemplateParamSpec parm3 = new ExperimentTemplateParamSpec();
            parm3.setName(String.format("spec.%s.resourceMap.memory", entrySet.getKey()));
            parm3.setValue(taskSpec.getMemory() == null ? "1" : taskSpec.getMemory().toString());
            parm3.setRequired("false");
            parm3.setDescription("");
            tplSpec.getExperimentTemplateParamSpec().add(parm3);
        }
        return tplSpec;
    }

    private ExperimentSpec parameterMapping(ExperimentTemplateSpec tplSpec) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (ExperimentTemplateParamSpec parm : tplSpec.getExperimentTemplateParamSpec()) {
            if (parm.getValue() != null) {
                paramMap.put(parm.getName(), parm.getValue());
                continue;
            }
            paramMap.put(parm.getName(), "");
        }
        return this.parameterMapping(tplSpec, paramMap);
    }

    private ExperimentSpec parameterMapping(ExperimentTemplateSpec tplspec, Map<String, String> paramMap) {
        String spec = gson.toJson((Object)tplspec.getExperimentSpec());
        Map flattenJson = JsonFlattener.flattenAsMap((String)spec);
        Log.info((String)flattenJson.toString());
        HashMap<String, ExperimentTemplateParamSpec> tplparamMap = new HashMap<String, ExperimentTemplateParamSpec>();
        for (Object tplParam : tplspec.getExperimentTemplateParamSpec()) {
            tplparamMap.put(tplParam.getName(), (ExperimentTemplateParamSpec)tplParam);
        }
        HashSet<String> illegalParamList = new HashSet<String>();
        for (String string : paramMap.keySet()) {
            if (tplparamMap.get(string) != null) continue;
            illegalParamList.add(string);
        }
        if (illegalParamList.size() > 0) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Parameters contains illegal key: " + ((Object)illegalParamList).toString());
        }
        HashSet<String> unmapedParamList = new HashSet<String>();
        for (Object tplParam : tplspec.getExperimentTemplateParamSpec()) {
            if (paramMap.get(tplParam.getName()) != null) continue;
            if (!Boolean.parseBoolean(tplParam.getRequired())) {
                paramMap.put(tplParam.getName(), tplParam.getValue());
                continue;
            }
            unmapedParamList.add(tplParam.getName());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : paramMap.keySet()) {
            hashSet.add(string);
        }
        for (Map.Entry entry : tplspec.getExperimentSpec().getSpec().entrySet()) {
            String string = paramMap.get(String.format("spec.%s.resourceMap.cpu", entry.getKey()));
            String memory = paramMap.get(String.format("spec.%s.resourceMap.memory", entry.getKey()));
            flattenJson.put(String.format("spec.%s.resources", entry.getKey()), String.format("cpu=%s,memory=%s", string, memory));
        }
        Pattern pattern = Pattern.compile("\\{\\{(.*?)\\}\\}");
        for (Map.Entry entry : flattenJson.entrySet()) {
            String key;
            boolean isMatch = false;
            if (entry.getValue() instanceof String) {
                String value = (String)entry.getValue();
                Matcher matcher = pattern.matcher(value);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String name = matcher.group(1);
                    String key2 = (String)entry.getKey() + ":" + name;
                    if (paramMap.get(key2) != null) {
                        isMatch = true;
                        matcher.appendReplacement(sb, paramMap.get(key2));
                        hashSet.remove(key2);
                        unmapedParamList.remove(key2);
                        continue;
                    }
                    if (paramMap.get(name) != null) {
                        isMatch = true;
                        matcher.appendReplacement(sb, paramMap.get(name));
                        hashSet.remove(name);
                        unmapedParamList.remove(name);
                        continue;
                    }
                    unmapedParamList.add(key2);
                }
                if (isMatch) {
                    matcher.appendTail(sb);
                    flattenJson.put(entry.getKey(), sb.toString());
                }
            }
            if (isMatch || paramMap.get(key = (String)entry.getKey()) == null) continue;
            flattenJson.put(key, paramMap.get(key));
            hashSet.remove(key);
        }
        if (hashSet.size() > 0) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Parameters contains unused key: " + ((Object)hashSet).toString());
        }
        if (unmapedParamList.size() > 0) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Template contains unmapped value: " + ((Object)unmapedParamList).toString());
        }
        String string = flattenJson.toString();
        Log.info((String)("flattenJson    " + string));
        String string2 = JsonUnflattener.unflatten((String)string);
        Log.info((String)("nestedJson    " + string2));
        ExperimentSpec returnExperimentSpec = null;
        try {
            returnExperimentSpec = (ExperimentSpec)gson.fromJson(string2, ExperimentSpec.class);
            Log.info((String)("ExperimentSpec " + returnExperimentSpec.toString()));
        }
        catch (Exception e) {
            throw new SubmarineRuntimeException(Response.Status.BAD_REQUEST.getStatusCode(), "Template mapping fail: " + e.getMessage() + string2);
        }
        return returnExperimentSpec;
    }

    static {
        gsonBuilder = new GsonBuilder().registerTypeAdapter(ExperimentId.class, (Object)new ExperimentIdSerializer()).registerTypeAdapter(ExperimentId.class, (Object)new ExperimentIdDeserializer());
        gson = gsonBuilder.setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }
}

