/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.common.CustomResourceType;
import org.apache.submarine.server.api.notebook.Notebook;
import org.apache.submarine.server.experiment.database.entity.ExperimentEntity;
import org.apache.submarine.server.experiment.database.service.ExperimentService;
import org.apache.submarine.server.notebook.database.service.NotebookService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServiceManager {
    private static volatile InternalServiceManager internalServiceManager;
    private static final Logger LOG;
    private final ExperimentService experimentService;
    private final NotebookService notebookService;

    public static InternalServiceManager getInstance() {
        if (internalServiceManager == null) {
            internalServiceManager = new InternalServiceManager(new ExperimentService(), new NotebookService());
        }
        return internalServiceManager;
    }

    @VisibleForTesting
    protected InternalServiceManager(ExperimentService experimentService, NotebookService notebookService) {
        this.experimentService = experimentService;
        this.notebookService = notebookService;
    }

    public boolean updateCRStatus(CustomResourceType crType, String resourceId, Map<String, Object> updateObject) {
        if (crType.equals((Object)CustomResourceType.Notebook)) {
            return this.updateNotebookStatus(resourceId, updateObject);
        }
        if (crType.equals((Object)CustomResourceType.TFJob) || crType.equals((Object)CustomResourceType.PyTorchJob)) {
            return this.updateExperimentStatus(resourceId, updateObject);
        }
        return false;
    }

    private boolean updateExperimentStatus(String resourceId, Map<String, Object> updateObject) {
        ExperimentEntity experimentEntity = this.experimentService.select(resourceId);
        if (experimentEntity == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), String.format("cannot find experiment with id:%s", resourceId));
        }
        if (updateObject.get("status") != null) {
            experimentEntity.setExperimentStatus(updateObject.get("status").toString());
        }
        if (updateObject.get("acceptedTime") != null) {
            experimentEntity.setAcceptedTime(DateTime.parse((String)updateObject.get("acceptedTime").toString()).toDate());
        }
        if (updateObject.get("createdTime") != null) {
            experimentEntity.setCreateTime(DateTime.parse((String)updateObject.get("createdTime").toString()).toDate());
        }
        if (updateObject.get("runningTime") != null) {
            experimentEntity.setRunningTime(DateTime.parse((String)updateObject.get("runningTime").toString()).toDate());
        }
        if (updateObject.get("finishedTime") != null) {
            experimentEntity.setFinishedTime(DateTime.parse((String)updateObject.get("finishedTime").toString()).toDate());
        }
        return this.experimentService.update(experimentEntity);
    }

    private boolean updateNotebookStatus(String resourceId, Map<String, Object> updateObject) {
        Notebook notebook = this.notebookService.select(resourceId);
        if (notebook == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), String.format("cannot find notebook with id:%s", resourceId));
        }
        if (updateObject.containsKey("status")) {
            notebook.setStatus(updateObject.get("status").toString());
        }
        if (updateObject.get("createTime") != null) {
            notebook.setCreatedTime(updateObject.get("createTime").toString());
        }
        if (updateObject.get("deletedTime") != null) {
            notebook.setDeletedTime(updateObject.get("deletedTime").toString());
        }
        if (updateObject.get("name") != null) {
            notebook.setName(updateObject.get("name").toString());
        }
        if (updateObject.get("reason") != null) {
            notebook.setReason(updateObject.get("reason").toString());
        }
        if (updateObject.get("url") != null) {
            notebook.setUrl(updateObject.get("url").toString());
        }
        return this.notebookService.update(notebook);
    }

    static {
        LOG = LoggerFactory.getLogger(InternalServiceManager.class);
    }
}

