/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.notebook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.SubmarineServer;
import org.apache.submarine.server.SubmitterManager;
import org.apache.submarine.server.api.Submitter;
import org.apache.submarine.server.api.environment.Environment;
import org.apache.submarine.server.api.notebook.Notebook;
import org.apache.submarine.server.api.notebook.NotebookId;
import org.apache.submarine.server.api.spec.NotebookSpec;
import org.apache.submarine.server.environment.EnvironmentManager;
import org.apache.submarine.server.notebook.database.service.NotebookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookManager.class);
    private static volatile NotebookManager manager;
    private final Submitter submitter;
    private final NotebookService notebookService;
    private final AtomicInteger notebookCounter = new AtomicInteger(0);

    private NotebookManager(Submitter submitter, NotebookService notebookService) {
        this.submitter = submitter;
        this.notebookService = notebookService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotebookManager getInstance() {
        if (manager != null) return manager;
        Class<NotebookManager> clazz = NotebookManager.class;
        synchronized (NotebookManager.class) {
            if (manager != null) return manager;
            manager = new NotebookManager(SubmitterManager.loadSubmitter(), new NotebookService());
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public Notebook createNotebook(NotebookSpec spec) throws SubmarineRuntimeException {
        this.checkNotebookSpec(spec);
        String lowerName = spec.getMeta().getName().toLowerCase();
        spec.getMeta().setName(lowerName);
        NotebookId notebookId = this.generateNotebookId();
        HashMap<String, String> labels = spec.getMeta().getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>();
        }
        labels.put("notebook-owner-id", spec.getMeta().getOwnerId());
        labels.put("notebook-id", notebookId.toString());
        spec.getMeta().setLabels(labels);
        Notebook notebook = this.submitter.createNotebook(spec, notebookId.toString());
        notebook.setNotebookId(notebookId);
        notebook.setSpec(spec);
        NotebookSpec notebookSpec = notebook.getSpec();
        EnvironmentManager environmentManager = EnvironmentManager.getInstance();
        Environment environment = environmentManager.getEnvironment(spec.getEnvironment().getName());
        if (environment.getEnvironmentSpec() != null) {
            notebookSpec.setEnvironment(environment.getEnvironmentSpec());
        }
        notebook.setStatus(Notebook.Status.STATUS_CREATING.getValue());
        this.notebookService.insert(notebook);
        return notebook;
    }

    public List<Notebook> listNotebooksByNamespace(String namespace) throws SubmarineRuntimeException {
        ArrayList<Notebook> notebookList = new ArrayList<Notebook>();
        for (Notebook notebook : this.notebookService.selectAll()) {
            if (namespace != null && namespace.length() != 0) continue;
            notebookList.add(notebook);
        }
        return notebookList;
    }

    public List<Notebook> listNotebooksByUserId(String id) {
        List<Notebook> serviceNotebooks = this.notebookService.selectAll();
        ArrayList<Notebook> notebookList = new ArrayList<Notebook>();
        for (Notebook nb : serviceNotebooks) {
            notebookList.add(nb);
        }
        return notebookList;
    }

    public Notebook getNotebook(String id) throws SubmarineRuntimeException {
        this.checkNotebookId(id);
        Notebook notebook = this.notebookService.select(id);
        if (notebook == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Notebook not found.");
        }
        Notebook foundNotebook = this.submitter.findNotebook(notebook.getSpec());
        foundNotebook.rebuild(notebook);
        foundNotebook.setNotebookId(NotebookId.fromString((String)id));
        return foundNotebook;
    }

    public Notebook deleteNotebook(String id) throws SubmarineRuntimeException {
        Notebook notebook = this.getNotebook(id);
        Notebook patchNotebook = this.submitter.deleteNotebook(notebook.getSpec(), id);
        this.notebookService.delete(id);
        notebook.rebuild(patchNotebook);
        return notebook;
    }

    private NotebookId generateNotebookId() {
        return NotebookId.newInstance((long)SubmarineServer.getServerTimeStamp(), (int)this.notebookCounter.incrementAndGet());
    }

    private void checkNotebookSpec(NotebookSpec spec) {
        if (spec == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Notebook Spec object is null.");
        }
        List<Notebook> serviceNotebooks = this.notebookService.selectAll();
        for (Notebook notebook : serviceNotebooks) {
            if (!notebook.getSpec().getMeta().getName().equals(spec.getMeta().getName())) continue;
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Notebook with same name is already existed.");
        }
    }

    private void checkNotebookId(String id) throws SubmarineRuntimeException {
        NotebookId notebookId = NotebookId.fromString((String)id);
        if (notebookId == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Notebook not found.");
        }
    }
}

