/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.notebook.database.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.notebook.Notebook;
import org.apache.submarine.server.api.notebook.NotebookId;
import org.apache.submarine.server.api.spec.NotebookSpec;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.notebook.database.entity.NotebookEntity;
import org.apache.submarine.server.notebook.database.mappers.NotebookMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookService {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookService.class);

    public List<Notebook> selectAll() throws SubmarineRuntimeException {
        List<NotebookEntity> entities;
        LOG.info("Notebook selectAll");
        ArrayList<Notebook> notebooks = new ArrayList<Notebook>();
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            NotebookMapper mapper = (NotebookMapper)sqlSession.getMapper(NotebookMapper.class);
            entities = mapper.selectAll();
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to get notebook entities from database");
        }
        for (NotebookEntity entity : entities) {
            notebooks.add(this.buildNotebookFromEntity(entity));
        }
        return notebooks;
    }

    public Notebook select(String id) throws SubmarineRuntimeException {
        NotebookEntity entity;
        LOG.info("Notebook select " + id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            NotebookMapper mapper = (NotebookMapper)sqlSession.getMapper(NotebookMapper.class);
            entity = mapper.select(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to get notebook entity from database");
        }
        if (entity != null) {
            Notebook notebook = this.buildNotebookFromEntity(entity);
            return notebook;
        }
        return null;
    }

    public boolean insert(Notebook notebook) throws SubmarineRuntimeException {
        LOG.info("Notebook insert");
        LOG.debug(notebook.toString());
        NotebookEntity entity = this.buildEntityFromNotebook(notebook);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            NotebookMapper mapper = (NotebookMapper)sqlSession.getMapper(NotebookMapper.class);
            mapper.insert(entity);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to insert notebook entity to database");
        }
        return true;
    }

    public boolean update(Notebook notebook) throws SubmarineRuntimeException {
        LOG.info("Notebook update");
        NotebookEntity entity = this.buildEntityFromNotebook(notebook);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            NotebookMapper mapper = (NotebookMapper)sqlSession.getMapper(NotebookMapper.class);
            mapper.update(entity);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to update notebook entity in database");
        }
        return true;
    }

    public boolean delete(String id) throws SubmarineRuntimeException {
        LOG.info("Notebook delete " + id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            NotebookMapper mapper = (NotebookMapper)sqlSession.getMapper(NotebookMapper.class);
            mapper.delete(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to delete notebook entity from database");
        }
        return true;
    }

    private NotebookEntity buildEntityFromNotebook(Notebook notebook) {
        NotebookEntity entity = new NotebookEntity();
        try {
            entity.setId(notebook.getNotebookId().toString());
            entity.setNotebookSpec(new GsonBuilder().disableHtmlEscaping().create().toJson((Object)notebook.getSpec()));
            entity.setNotebookStatus(notebook.getStatus());
            entity.setNotebookUrl(notebook.getUrl());
            entity.setReason(notebook.getReason());
            if (notebook.getCreatedTime() != null) {
                entity.setCreateTime(DateTime.parse((String)notebook.getCreatedTime()).toDate());
            }
            if (notebook.getDeletedTime() != null) {
                entity.setDeletedTime(DateTime.parse((String)notebook.getDeletedTime()).toDate());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to build entity from notebook");
        }
        return entity;
    }

    private Notebook buildNotebookFromEntity(NotebookEntity entity) {
        Notebook notebook = new Notebook();
        try {
            notebook.setNotebookId(NotebookId.fromString((String)entity.getId()));
            notebook.setSpec((NotebookSpec)new Gson().fromJson(entity.getNotebookSpec(), NotebookSpec.class));
            notebook.setName(notebook.getSpec().getMeta().getName());
            notebook.setStatus(entity.getNotebookStatus());
            notebook.setCreatedTime(new DateTime((Object)entity.getCreateTime()).toString());
            notebook.setUrl(entity.getNotebookUrl());
            notebook.setReason(entity.getReason());
            if (entity.getDeletedTime() != null) {
                notebook.setDeletedTime(new DateTime((Object)entity.getDeletedTime()).toString());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException("Unable to build notebook from entity");
        }
        return notebook;
    }
}

