/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.cluster.ClusterServer;
import org.apache.submarine.commons.cluster.meta.ClusterMeta;
import org.apache.submarine.commons.cluster.meta.ClusterMetaType;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1/cluster")
@Produces(value={"application/json"})
public class ClusterRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRestApi.class);
    Gson gson = new Gson();
    private ClusterServer clusterServer = ClusterServer.getInstance();

    @VisibleForTesting
    public void setClusterServer(ClusterServer clusterServer) {
        this.clusterServer = clusterServer;
    }

    @GET
    @Path(value="/address")
    @SubmarineApi
    public Response getClusterAddress() {
        SubmarineConfiguration sConf = SubmarineConfiguration.getInstance();
        String clusterAddr = sConf.getClusterAddress();
        String[] arrAddr = clusterAddr.split(",");
        List<String> listAddr = Arrays.asList(arrAddr);
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listAddr).build();
    }

    @GET
    @Path(value="/nodes")
    @SubmarineApi
    public Response getClusterNodes() {
        ArrayList nodes = new ArrayList();
        HashMap clusterMeta = null;
        HashMap intpMeta = null;
        clusterMeta = this.clusterServer.getClusterMeta(ClusterMetaType.SERVER_META, "");
        intpMeta = this.clusterServer.getClusterMeta(ClusterMetaType.INTP_PROCESS_META, "");
        for (Map.Entry serverMetaEntity : clusterMeta.entrySet()) {
            if (!((HashMap)serverMetaEntity.getValue()).containsKey(ClusterMeta.NODE_NAME)) continue;
            String serverNodeName = (String)((HashMap)serverMetaEntity.getValue()).get(ClusterMeta.NODE_NAME);
            ArrayList<String> arrIntpProcess = new ArrayList<String>();
            int intpProcCount = 0;
            for (Map.Entry intpMetaEntity : intpMeta.entrySet()) {
                String intpNodeName;
                if (!((HashMap)intpMetaEntity.getValue()).containsKey(ClusterMeta.NODE_NAME) && !((HashMap)intpMetaEntity.getValue()).containsKey(ClusterMeta.INTP_PROCESS_NAME) || !serverNodeName.equals(intpNodeName = (String)((HashMap)intpMetaEntity.getValue()).get(ClusterMeta.NODE_NAME))) continue;
                ++intpProcCount;
                String intpName = (String)((HashMap)intpMetaEntity.getValue()).get(ClusterMeta.INTP_PROCESS_NAME);
                arrIntpProcess.add(intpName);
            }
            ((HashMap)serverMetaEntity.getValue()).put(ClusterMeta.INTP_PROCESS_COUNT, intpProcCount);
            ((HashMap)serverMetaEntity.getValue()).put(ClusterMeta.INTP_PROCESS_LIST, arrIntpProcess);
        }
        for (Map.Entry entry : clusterMeta.entrySet()) {
            String nodeName = (String)entry.getKey();
            Map properties = (Map)entry.getValue();
            HashMap<String, String> sortProperties = new HashMap<String, String>();
            if (properties.containsKey(ClusterMeta.CPU_USED) && properties.containsKey(ClusterMeta.CPU_CAPACITY)) {
                float cpuUsed = (float)((Long)properties.get(ClusterMeta.CPU_USED)).longValue() / 100.0f;
                float cpuCapacity = (float)((Long)properties.get(ClusterMeta.CPU_CAPACITY)).longValue() / 100.0f;
                float cpuRate = cpuUsed / cpuCapacity * 100.0f;
                String cpuInfo = String.format("%.2f / %.2f = %.2f", Float.valueOf(cpuUsed), Float.valueOf(cpuCapacity), Float.valueOf(cpuRate));
                sortProperties.put(ClusterMeta.CPU_USED + " / " + ClusterMeta.CPU_CAPACITY, cpuInfo + "%");
            }
            if (properties.containsKey(ClusterMeta.MEMORY_USED) && properties.containsKey(ClusterMeta.MEMORY_CAPACITY)) {
                float memoryUsed = (float)((Long)properties.get(ClusterMeta.MEMORY_USED)).longValue() / 1.0737418E9f;
                float memoryCapacity = (float)((Long)properties.get(ClusterMeta.MEMORY_CAPACITY)).longValue() / 1.0737418E9f;
                float memoryRate = memoryUsed / memoryCapacity * 100.0f;
                String memoryInfo = String.format("%.2fGB / %.2fGB = %.2f", Float.valueOf(memoryUsed), Float.valueOf(memoryCapacity), Float.valueOf(memoryRate));
                sortProperties.put(ClusterMeta.MEMORY_USED + " / " + ClusterMeta.MEMORY_CAPACITY, memoryInfo + "%");
            }
            if (properties.containsKey(ClusterMeta.SERVER_START_TIME)) {
                Object serverStartTime = properties.get(ClusterMeta.SERVER_START_TIME);
                if (serverStartTime instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)serverStartTime;
                    String dateTime = this.formatLocalDateTime(localDateTime);
                    sortProperties.put(ClusterMeta.SERVER_START_TIME, dateTime);
                } else {
                    sortProperties.put(ClusterMeta.SERVER_START_TIME, "Wrong time type!");
                }
            }
            if (properties.containsKey(ClusterMeta.STATUS)) {
                sortProperties.put(ClusterMeta.STATUS, (String)properties.get(ClusterMeta.STATUS));
            }
            if (properties.containsKey(ClusterMeta.LATEST_HEARTBEAT)) {
                Object latestHeartbeat = properties.get(ClusterMeta.LATEST_HEARTBEAT);
                if (latestHeartbeat instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)latestHeartbeat;
                    String dateTime = this.formatLocalDateTime(localDateTime);
                    sortProperties.put(ClusterMeta.LATEST_HEARTBEAT, dateTime);
                } else {
                    sortProperties.put(ClusterMeta.LATEST_HEARTBEAT, "Wrong time type!");
                }
            }
            if (properties.containsKey(ClusterMeta.INTP_PROCESS_LIST)) {
                sortProperties.put(ClusterMeta.INTP_PROCESS_LIST, (String)properties.get(ClusterMeta.INTP_PROCESS_LIST));
            }
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put(ClusterMeta.NODE_NAME, nodeName);
            node.put(ClusterMeta.PROPERTIES, sortProperties);
            nodes.add(node);
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(nodes).build();
    }

    @GET
    @Path(value="/node/{nodeName}/{intpName}")
    @SubmarineApi
    public Response getClusterNode(@PathParam(value="nodeName") String nodeName, @PathParam(value="intpName") String intpName) {
        ArrayList intpProcesses = new ArrayList();
        HashMap intpMeta = null;
        intpMeta = this.clusterServer.getClusterMeta(ClusterMetaType.INTP_PROCESS_META, "");
        for (Map.Entry intpMetaEntity : intpMeta.entrySet()) {
            String dateTime;
            LocalDateTime localDateTime;
            String intpNodeName = (String)((HashMap)intpMetaEntity.getValue()).get(ClusterMeta.NODE_NAME);
            if (null == intpNodeName || !intpNodeName.equals(nodeName)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(ClusterMeta.NODE_NAME, intpNodeName);
            node.put(ClusterMeta.PROPERTIES, (String)intpMetaEntity.getValue());
            HashMap properties = (HashMap)intpMetaEntity.getValue();
            if (properties.containsKey(ClusterMeta.INTP_START_TIME)) {
                Object intpStartTime = properties.get(ClusterMeta.INTP_START_TIME);
                if (intpStartTime instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)intpStartTime;
                    dateTime = this.formatLocalDateTime(localDateTime);
                    properties.put(ClusterMeta.INTP_START_TIME, dateTime);
                } else {
                    properties.put(ClusterMeta.INTP_START_TIME, "Wrong time type!");
                }
            }
            if (properties.containsKey(ClusterMeta.LATEST_HEARTBEAT)) {
                Object latestHeartbeat = properties.get(ClusterMeta.LATEST_HEARTBEAT);
                if (latestHeartbeat instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)latestHeartbeat;
                    dateTime = this.formatLocalDateTime(localDateTime);
                    properties.put(ClusterMeta.LATEST_HEARTBEAT, dateTime);
                } else {
                    properties.put(ClusterMeta.LATEST_HEARTBEAT, "Wrong time type!");
                }
            }
            intpProcesses.add(node);
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(intpProcesses).build();
    }

    private String formatLocalDateTime(LocalDateTime localDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String strDate = localDateTime.format(dtf);
        return strDate;
    }
}

