/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.environment.Environment;
import org.apache.submarine.server.api.spec.EnvironmentSpec;
import org.apache.submarine.server.environment.EnvironmentManager;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/environment")
@Produces(value={"application/json; charset=utf-8"})
public class EnvironmentRestApi {
    private final EnvironmentManager environmentManager = EnvironmentManager.getInstance();

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a environment", tags={"environment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createEnvironment(EnvironmentSpec spec) {
        try {
            Environment environment = this.environmentManager.createEnvironment(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(environment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseEnvironmentServiceException(e);
        }
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Update the environment with job spec", tags={"environment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Environment not found")})
    public Response updateEnvironment(@PathParam(value="id") String name, EnvironmentSpec spec) {
        try {
            Environment environment = this.environmentManager.updateEnvironment(name, spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(environment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseEnvironmentServiceException(e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete the environment", tags={"environment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Environment not found")})
    public Response deleteEnvironment(@PathParam(value="id") String name) {
        try {
            Environment environment = this.environmentManager.deleteEnvironment(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(environment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseEnvironmentServiceException(e);
        }
    }

    @GET
    @Operation(summary="List of Environments", tags={"environment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listEnvironment(@QueryParam(value="status") String status) {
        try {
            List<Environment> environmentList = this.environmentManager.listEnvironments(status);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(environmentList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseEnvironmentServiceException(e);
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Find environment by name", tags={"environment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Environment not found")})
    public Response getEnvironment(@PathParam(value="id") String name) {
        try {
            Environment environment = this.environmentManager.getEnvironment(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(environment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseEnvironmentServiceException(e);
        }
    }

    private Response parseEnvironmentServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }
}

