/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.api.experiment.ExperimentLog;
import org.apache.submarine.server.api.experiment.MlflowInfo;
import org.apache.submarine.server.api.experiment.TensorboardInfo;
import org.apache.submarine.server.api.experimenttemplate.ExperimentTemplateSubmit;
import org.apache.submarine.server.api.spec.ExperimentSpec;
import org.apache.submarine.server.experiment.ExperimentManager;
import org.apache.submarine.server.experimenttemplate.ExperimentTemplateManager;
import org.apache.submarine.server.s3.Client;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/experiment")
@Produces(value={"application/json; charset=utf-8"})
public class ExperimentRestApi {
    private ExperimentManager experimentManager = ExperimentManager.getInstance();
    private final Client minioClient = new Client();

    @VisibleForTesting
    public void setExperimentManager(ExperimentManager experimentManager) {
        this.experimentManager = experimentManager;
    }

    @GET
    @Path(value="ping")
    @Consumes(value={"application/json"})
    @Operation(summary="Ping submarine server", tags={"experiment"}, description="Return the Pong message for test the connectivity", responses={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response ping() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result("Pong").build();
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create an experiment", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createExperiment(ExperimentSpec spec) {
        try {
            Experiment experiment = this.experimentManager.createExperiment(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experiment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @POST
    @Path(value="/{name}")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="use experiment template to create an experiment", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response SubmitExperimentTemplate(@PathParam(value="name") String name, ExperimentTemplateSubmit spec) {
        try {
            spec.setName(name);
            Experiment experiment = ExperimentTemplateManager.getInstance().submitExperimentTemplate(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experiment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Operation(summary="List experiments", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listExperiments(@QueryParam(value="status") String status) {
        try {
            List<Experiment> experimentList = this.experimentManager.listExperimentsByStatus(status);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get the experiment's detailed info by id", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Experiment not found")})
    public Response getExperiment(@PathParam(value="id") String id) {
        try {
            Experiment experiment = this.experimentManager.getExperiment(id);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experiment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Update the experiment in the submarine server with spec", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Experiment not found")})
    public Response patchExperiment(@PathParam(value="id") String id, ExperimentSpec spec) {
        try {
            Experiment experiment = this.experimentManager.patchExperiment(id, spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experiment).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete the experiment", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Experiment not found")})
    public Response deleteExperiment(@PathParam(value="id") String id) {
        Experiment experiment;
        try {
            this.minioClient.deleteArtifactsByExperiment(id);
            experiment = this.experimentManager.deleteExperiment(id);
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(experiment).build();
    }

    @GET
    @Path(value="/logs")
    @Operation(summary="List experiment's log", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listLog(@QueryParam(value="status") String status) {
        try {
            List<ExperimentLog> experimentLogList = this.experimentManager.listExperimentLogsByStatus(status);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentLogList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Path(value="/logs/{id}")
    @Operation(summary="Log experiment by id", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Experiment not found")})
    public Response getLog(@PathParam(value="id") String id) {
        try {
            ExperimentLog experimentLog = this.experimentManager.getExperimentLog(id);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentLog).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Path(value="/artifacts/{id}")
    @Operation(summary="List artifact paths by id", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Experiment not found")})
    public Response getArtifactPaths(@PathParam(value="id") String id) {
        try {
            List<String> artifactPaths = this.minioClient.listArtifact(String.format("experiment/%s", id));
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(artifactPaths).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Path(value="/tensorboard")
    @Operation(summary="Get tensorboard's information", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Tensorboard not found")})
    public Response getTensorboardInfo() {
        try {
            TensorboardInfo tensorboardInfo = this.experimentManager.getTensorboardInfo();
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(tensorboardInfo).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    @GET
    @Path(value="/mlflow")
    @Operation(summary="Get mlflow's information", tags={"experiment"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="MLflow not found")})
    public Response getMLflowInfo() {
        try {
            MlflowInfo mlflowInfo = this.experimentManager.getMLflowInfo();
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(mlflowInfo).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentServiceException(e);
        }
    }

    private Response parseExperimentServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage().equals("Conflict") ? "Duplicated experiment name" : e.getMessage()).build();
    }
}

