/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.experimenttemplate.ExperimentTemplate;
import org.apache.submarine.server.api.spec.ExperimentTemplateSpec;
import org.apache.submarine.server.experimenttemplate.ExperimentTemplateManager;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/template")
@Produces(value={"application/json; charset=utf-8"})
public class ExperimentTemplateRestApi {
    private final ExperimentTemplateManager experimentTemplateManager = ExperimentTemplateManager.getInstance();

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a experimentTemplate", tags={"experimentTemplate"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createExperimentTemplate(ExperimentTemplateSpec spec) {
        try {
            ExperimentTemplate experimentTemplate = this.experimentTemplateManager.createExperimentTemplate(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentTemplate).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentTemplateServiceException(e);
        }
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Update the experimentTemplate with job spec", tags={"experimentTemplates"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ExperimentTemplate not found")})
    public Response updateExperimentTemplate(@PathParam(value="id") String name, ExperimentTemplateSpec spec) {
        try {
            ExperimentTemplate experimentTemplate = this.experimentTemplateManager.updateExperimentTemplate(name, spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentTemplate).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentTemplateServiceException(e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete the experimentTemplate", tags={"experimentTemplates"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ExperimentTemplate not found")})
    public Response deleteExperimentTemplate(@PathParam(value="id") String name) {
        try {
            ExperimentTemplate experimentTemplate = this.experimentTemplateManager.deleteExperimentTemplate(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentTemplate).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentTemplateServiceException(e);
        }
    }

    @GET
    @Operation(summary="List of ExperimentTemplates", tags={"experimentTemplates"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listExperimentTemplate(@QueryParam(value="status") String status) {
        try {
            List<ExperimentTemplate> experimentTemplateList = this.experimentTemplateManager.listExperimentTemplates(status);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentTemplateList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentTemplateServiceException(e);
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Find experimentTemplate by name", tags={"experimentTemplate"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ExperimentTemplate not found")})
    public Response getExperimentTemplate(@PathParam(value="id") String name) {
        try {
            ExperimentTemplate experimentTemplate = this.experimentTemplateManager.getExperimentTemplate(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(experimentTemplate).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseExperimentTemplateServiceException(e);
        }
    }

    private Response parseExperimentTemplateServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }
}

