/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.common.CustomResourceType;
import org.apache.submarine.server.internal.InternalServiceManager;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1/internal")
@Produces(value={"application/json"})
public class InternalServiceRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(InternalServiceRestApi.class);
    private InternalServiceManager internalServiceManager = InternalServiceManager.getInstance();

    @VisibleForTesting
    public void setInternalServiceManager(InternalServiceManager internalServiceManager) {
        this.internalServiceManager = internalServiceManager;
    }

    @POST
    @Path(value="/{customResourceType}/{resourceId}")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Update the environment with job spec", tags={"environments"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="resource not found")})
    public Response updateEnvironment(@PathParam(value="customResourceType") String type, @PathParam(value="resourceId") String resourceId, Map<String, Object> updatedCustomObject) {
        try {
            LOG.info("In:" + new Gson().toJson(updatedCustomObject));
            this.internalServiceManager.updateCRStatus(CustomResourceType.valueOf((String)type), resourceId, updatedCustomObject);
            return new JsonResponse.Builder(Response.Status.OK).success(true).build();
        }
        catch (SubmarineRuntimeException e) {
            return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
        }
    }
}

