/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.model.database.entities.ModelVersionEntity;
import org.apache.submarine.server.model.database.entities.ModelVersionTagEntity;
import org.apache.submarine.server.model.database.service.ModelVersionService;
import org.apache.submarine.server.model.database.service.ModelVersionTagService;
import org.apache.submarine.server.s3.Client;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.json.JSONObject;

@Path(value="v1/model-version")
@Produces(value={"application/json; charset=utf-8"})
public class ModelVersionRestApi {
    private final ModelVersionService modelVersionService = new ModelVersionService();
    private final ModelVersionTagService modelVersionTagService = new ModelVersionTagService();
    private final Client s3Client = new Client();

    @GET
    @Path(value="ping")
    @Consumes(value={"application/json"})
    @Operation(summary="Ping submarine server", tags={"model-version"}, description="Return the Pong message for test the connectivity", responses={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response ping() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result("Pong").build();
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a model version instance", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createModelVersion(ModelVersionEntity entity, @QueryParam(value="baseDir") String baseDir) {
        try {
            String res = new String(this.s3Client.downloadArtifact(String.format("%s/description.json", baseDir)));
            JSONObject description = new JSONObject(res);
            String modelType = description.get("model_type").toString();
            String id = description.get("id").toString();
            entity.setId(id);
            entity.setModelType(modelType);
            int version = this.modelVersionService.selectAllVersions(entity.getName()).stream().mapToInt(ModelVersionEntity::getVersion).max().orElse(0) + 1;
            entity.setVersion(version);
            this.modelVersionService.insert(entity);
            String uniqueModelPath = String.format("%s-%d-%s", entity.getName(), version, id);
            this.s3Client.listAllObjects(baseDir).forEach(s -> {
                String relativePath = s.substring(String.format("%s/", baseDir).length());
                this.s3Client.copyArtifact(String.format("registry/%s/%s/%d/%s", uniqueModelPath, entity.getName(), entity.getVersion(), relativePath), (String)s);
            });
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a model version instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @GET
    @Path(value="/{name}")
    @Operation(summary="List model versions", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listModelVersions(@PathParam(value="name") String name) {
        try {
            List<ModelVersionEntity> modelVersionList = this.modelVersionService.selectAllVersions(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("List all model version instances").result(modelVersionList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @GET
    @Path(value="/{name}/{version}")
    @Operation(summary="Get detailed info about the model version", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ModelVersionEntity not found")})
    public Response getModelVersion(@PathParam(value="name") String name, @PathParam(value="version") Integer version) {
        try {
            ModelVersionEntity modelVersion = this.modelVersionService.selectWithTag(name, version);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Get the model version instance").result(modelVersion).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @DELETE
    @Path(value="/{name}/{version}")
    @Operation(summary="Delete the model version", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ModelVersionEntity not found")})
    public Response deleteModelVersion(@PathParam(value="name") String name, @PathParam(value="version") Integer version) {
        try {
            ModelVersionEntity spec = this.modelVersionService.select(name, version);
            this.s3Client.deleteArtifactsByModelVersion(name, version, spec.getId());
            this.modelVersionService.delete(name, version);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete the model version instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @PATCH
    @Path(value="")
    @Operation(summary="Update the model version", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="ModelVersionEntity not found")})
    public Response updateModelVersion(ModelVersionEntity entity) {
        try {
            this.checkModelVersion(entity);
            this.modelVersionService.update(entity);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Update the model version instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @POST
    @Path(value="/tag")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a model version tag instance", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createModelVersionTag(@DefaultValue(value="") @QueryParam(value="name") String name, @DefaultValue(value="") @QueryParam(value="version") String version, @DefaultValue(value="") @QueryParam(value="tag") String tag) {
        try {
            this.checkModelVersionTag(name, version, tag);
            ModelVersionTagEntity modelVersionTag = new ModelVersionTagEntity();
            modelVersionTag.setName(name);
            modelVersionTag.setVersion(Integer.parseInt(version));
            modelVersionTag.setTag(tag);
            this.modelVersionTagService.insert(modelVersionTag);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a model version tag instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    @DELETE
    @Path(value="/tag")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Delete a model version tag instance", tags={"model-version"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response deleteModelVersionTag(@DefaultValue(value="") @QueryParam(value="name") String name, @DefaultValue(value="") @QueryParam(value="version") String version, @DefaultValue(value="") @QueryParam(value="tag") String tag) {
        try {
            this.checkModelVersionTag(name, version, tag);
            ModelVersionTagEntity modelVersionTag = new ModelVersionTagEntity();
            modelVersionTag.setName(name);
            modelVersionTag.setVersion(Integer.parseInt(version));
            modelVersionTag.setTag(tag);
            this.modelVersionTagService.delete(modelVersionTag);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete a model version tag instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseModelVersionServiceException(e);
        }
    }

    private Response parseModelVersionServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }

    private void checkModelVersion(ModelVersionEntity entity) {
        if (entity == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version entity object is null.");
        }
        if (entity.getName() == null || entity.getName().equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's name is null.");
        }
        if (entity.getVersion() == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's version is null.");
        }
        ModelVersionEntity modelVersion = this.modelVersionService.select(entity.getName(), entity.getVersion());
        if (modelVersion == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Invalid. Model version entity with same name and version is not existed.");
        }
    }

    private void checkModelVersionTag(String name, String version, String tag) {
        int versionNum;
        if (name.equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's name is null.");
        }
        if (version.equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's version is null.");
        }
        try {
            versionNum = Integer.parseInt(version);
            if (versionNum < 1) {
                throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's version must be bigger than 0.");
            }
        }
        catch (NumberFormatException e) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Model version's version must be an integer.");
        }
        if (tag.equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Tag name is null.");
        }
        ModelVersionEntity modelVersion = this.modelVersionService.select(name, versionNum);
        if (modelVersion == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Invalid. Model version " + name + " version " + versionNum + " is not existed.");
        }
    }
}

