/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.notebook.Notebook;
import org.apache.submarine.server.api.spec.NotebookSpec;
import org.apache.submarine.server.notebook.NotebookManager;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/notebook")
@Produces(value={"application/json; charset=utf-8"})
public class NotebookRestApi {
    private final NotebookManager notebookManager = NotebookManager.getInstance();

    @GET
    @Path(value="ping")
    @Consumes(value={"application/json"})
    @Operation(summary="Ping submarine server", tags={"notebook"}, description="Return the Pong message for test the connectivity", responses={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response ping() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result("Pong").build();
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a notebook instance", tags={"notebook"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createNotebook(NotebookSpec spec) {
        try {
            Notebook notebook = this.notebookManager.createNotebook(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a notebook instance").result(notebook).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseNotebookServiceException(e);
        }
    }

    @GET
    @Operation(summary="List notebooks", tags={"notebook"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listNotebooks(@QueryParam(value="id") String id) {
        try {
            List<Notebook> notebookList = this.notebookManager.listNotebooksByUserId(id);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("List all notebook instances").result(notebookList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseNotebookServiceException(e);
        }
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get detailed info about the notebook", tags={"notebook"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Notebook not found")})
    public Response getNotebook(@PathParam(value="id") String id) {
        try {
            Notebook notebook = this.notebookManager.getNotebook(id);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Get the notebook instance").result(notebook).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseNotebookServiceException(e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete the notebook", tags={"notebook"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Notebook not found")})
    public Response deleteNotebook(@PathParam(value="id") String id) {
        try {
            Notebook notebook = this.notebookManager.deleteNotebook(id);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete the notebook instance").result(notebook).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseNotebookServiceException(e);
        }
    }

    private Response parseNotebookServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }
}

