/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.model.database.entities.ModelVersionEntity;
import org.apache.submarine.server.model.database.entities.RegisteredModelEntity;
import org.apache.submarine.server.model.database.entities.RegisteredModelTagEntity;
import org.apache.submarine.server.model.database.service.ModelVersionService;
import org.apache.submarine.server.model.database.service.RegisteredModelService;
import org.apache.submarine.server.model.database.service.RegisteredModelTagService;
import org.apache.submarine.server.s3.Client;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/registered-model")
@Produces(value={"application/json; charset=utf-8"})
public class RegisteredModelRestApi {
    private final RegisteredModelService registeredModelService = new RegisteredModelService();
    private final ModelVersionService modelVersionService = new ModelVersionService();
    private final RegisteredModelTagService registeredModelTagService = new RegisteredModelTagService();
    private final Client s3Client = new Client();

    @GET
    @Path(value="ping")
    @Consumes(value={"application/json"})
    @Operation(summary="Ping submarine server", tags={"registered-model"}, description="Return the Pong message for test the connectivity", responses={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response ping() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result("Pong").build();
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a registered model instance", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createRegisteredModel(RegisteredModelEntity entity) {
        try {
            this.checkRegisteredModel(entity);
            this.registeredModelService.insert(entity);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a registered model instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    @GET
    @Operation(summary="List registered models", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response listRegisteredModels() {
        try {
            List<RegisteredModelEntity> registeredModelList = this.registeredModelService.selectAll();
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("List all registered model instances").result(registeredModelList).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    @GET
    @Path(value="/{name}")
    @Operation(summary="Get detailed info about the registered model", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="RegisteredModelEntity not found")})
    public Response getRegisteredModel(@PathParam(value="name") String name) {
        try {
            RegisteredModelEntity registeredModel = this.registeredModelService.selectWithTag(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Get the registered model instance").result(registeredModel).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    @PATCH
    @Path(value="/{name}")
    @Operation(summary="Update the registered model", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="RegisteredModelEntity not found")})
    public Response updateRegisteredModel(@PathParam(value="name") String name, RegisteredModelEntity entity) {
        try {
            RegisteredModelEntity oldRegisteredModelEntity = this.registeredModelService.select(name);
            if (oldRegisteredModelEntity == null) {
                throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Invalid. Registered model " + name + " is not existed.");
            }
            this.checkRegisteredModel(entity);
            if (!name.equals(entity.getName())) {
                this.registeredModelService.rename(name, entity.getName());
            }
            this.registeredModelService.update(entity);
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).message("Update the registered model instance").build();
    }

    @DELETE
    @Path(value="/{name}")
    @Operation(summary="Delete the registered model", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="RegisteredModelEntity not found"), @ApiResponse(responseCode="406", description="Some version of models are in the production stage"), @ApiResponse(responseCode="500", description="Some error happen in server")})
    public Response deleteRegisteredModel(@PathParam(value="name") String name) {
        try {
            List<ModelVersionEntity> modelVersions = this.modelVersionService.selectAllVersions(name);
            modelVersions.forEach(modelVersion -> {
                String stage = modelVersion.getCurrentStage();
                if (stage.equals("Production")) {
                    throw new SubmarineRuntimeException(Response.Status.NOT_ACCEPTABLE.getStatusCode(), "Invalid. Some version of models are in the production stage");
                }
            });
            this.deleteModelInS3(modelVersions);
            this.registeredModelService.delete(name);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete the registered model instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    @POST
    @Path(value="/tag")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a registered model tag instance", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createRegisteredModelTag(@DefaultValue(value="") @QueryParam(value="name") String name, @DefaultValue(value="") @QueryParam(value="tag") String tag) {
        try {
            this.checkRegisteredModelTag(name, tag);
            RegisteredModelTagEntity registeredModelTag = new RegisteredModelTagEntity();
            registeredModelTag.setName(name);
            registeredModelTag.setTag(tag);
            this.registeredModelTagService.insert(registeredModelTag);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a registered model tag instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    @DELETE
    @Path(value="/tag")
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Delete a registered model tag instance", tags={"registered-model"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response deleteRegisteredModelTag(@DefaultValue(value="") @QueryParam(value="name") String name, @DefaultValue(value="") @QueryParam(value="tag") String tag) {
        try {
            this.checkRegisteredModelTag(name, tag);
            RegisteredModelTagEntity registeredModelTag = new RegisteredModelTagEntity();
            registeredModelTag.setName(name);
            registeredModelTag.setTag(tag);
            this.registeredModelTagService.delete(registeredModelTag);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete a registered model tag instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseRegisteredModelServiceException(e);
        }
    }

    private Response parseRegisteredModelServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }

    private void checkRegisteredModel(RegisteredModelEntity entity) {
        if (entity == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Registered model entity object is null.");
        }
        if (entity.getName() == null || entity.getName().equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Registered model name is null.");
        }
    }

    private void deleteModelInS3(List<ModelVersionEntity> modelVersions) throws SubmarineRuntimeException {
        try {
            modelVersions.forEach(modelVersion -> this.s3Client.deleteArtifactsByModelVersion(modelVersion.getName(), modelVersion.getVersion(), modelVersion.getId()));
        }
        catch (SubmarineRuntimeException e) {
            throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Some error happen when deleting the model in s3 bucket.");
        }
    }

    private void checkRegisteredModelTag(String name, String tag) {
        if (name.equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Registered model name is null.");
        }
        if (tag.equals("")) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid. Tag name is null.");
        }
        RegisteredModelEntity registeredModel = this.registeredModelService.select(name);
        if (registeredModel == null) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Invalid. Registered model " + name + " is not existed.");
        }
    }
}

