/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.model.ServeResponse;
import org.apache.submarine.server.api.model.ServeSpec;
import org.apache.submarine.server.model.ModelManager;
import org.apache.submarine.server.utils.response.JsonResponse;

@Path(value="v1/serve")
@Produces(value={"application/json; charset=utf-8"})
public class ServeRestApi {
    private final ModelManager modelManager = ModelManager.getInstance();

    @GET
    @Path(value="ping")
    @Consumes(value={"application/json"})
    @Operation(summary="Ping submarine server", tags={"serve"}, description="Return the Pong message for test the connectivity", responses={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response ping() {
        return new JsonResponse.Builder(Response.Status.OK).success(true).result("Pong").build();
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Operation(summary="Create a serve instance", tags={"serve"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))})})
    public Response createServe(ServeSpec spec) {
        try {
            ServeResponse serveResponse = this.modelManager.createServe(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Create a serve instance").result(serveResponse).build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseServeServiceException(e);
        }
    }

    @DELETE
    @Operation(summary="Delete the serve instance.", tags={"serve"}, responses={@ApiResponse(description="successful operation", content={@Content(schema=@Schema(implementation=JsonResponse.class))}), @ApiResponse(responseCode="404", description="Serve not found.")})
    public Response deleteServe(ServeSpec spec) {
        try {
            this.modelManager.deleteServe(spec);
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Delete the model serve instance").build();
        }
        catch (SubmarineRuntimeException e) {
            return this.parseServeServiceException(e);
        }
    }

    private Response parseServeServiceException(SubmarineRuntimeException e) {
        return new JsonResponse.Builder(e.getCode()).message(e.getMessage()).build();
    }
}

