/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest.workbench;

import java.sql.Timestamp;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.server.rest.workbench.LoginRestApi;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.apache.submarine.server.workbench.database.entity.MetricEntity;
import org.apache.submarine.server.workbench.database.service.MetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metric")
@Produces(value={"application/json"})
@Singleton
public class MetricRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRestApi.class);
    MetricService metricService = new MetricService();

    @Inject
    public MetricRestApi() {
    }

    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response listMetric(@QueryParam(value="metricKey") String metricKey, @QueryParam(value="value") Float value, @QueryParam(value="workerIndex") String workerIndex, @QueryParam(value="timestamp") Timestamp timestamp, @QueryParam(value="step") Integer step, @QueryParam(value="isNan") Boolean isNan, @QueryParam(value="id") String id) {
        List<MetricEntity> metrics;
        MetricEntity metric = new MetricEntity();
        metric.setKey(metricKey);
        metric.setValue(value);
        metric.setWorkerIndex(workerIndex);
        metric.setTimestamp(timestamp);
        metric.setStep(step);
        metric.setIsNan(isNan);
        metric.setId(id);
        LOG.info("listMetric ({})", (Object)metric);
        try {
            metrics = this.metricService.selectByPrimaryKeySelective(metric);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(metrics).build();
    }

    @GET
    @Path(value="/{id}")
    @SubmarineApi
    public Response getMetric(@PathParam(value="id") String id) {
        MetricEntity metric;
        try {
            metric = this.metricService.selectById(id);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(true).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(metric).build();
    }

    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response postMetric(MetricEntity metric) {
        boolean result = false;
        try {
            result = this.metricService.insert(metric);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response deleteMetric(@QueryParam(value="id") String id) {
        boolean result = false;
        try {
            result = this.metricService.deleteById(id);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response putMetric(MetricEntity metric) {
        boolean result = false;
        try {
            result = this.metricService.update(metric);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @POST
    @Path(value="/selective")
    @SubmarineApi
    public Response selectByPrimaryKeySelective(MetricEntity metric) {
        List<MetricEntity> metrics;
        try {
            metrics = this.metricService.selectByPrimaryKeySelective(metric);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(metrics).build();
    }
}

