/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest.workbench;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.server.rest.workbench.LoginRestApi;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.apache.submarine.server.workbench.database.entity.ParamEntity;
import org.apache.submarine.server.workbench.database.service.ParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/param")
@Produces(value={"application/json"})
@Singleton
public class ParamRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRestApi.class);
    ParamService paramService = new ParamService();

    @Inject
    public ParamRestApi() {
    }

    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response listParam(@QueryParam(value="id") String id, @QueryParam(value="paramKey") String paramKey, @QueryParam(value="value") String value, @QueryParam(value="workerIndex") String workerIndex) {
        List<ParamEntity> params;
        ParamEntity param = new ParamEntity();
        param.setId(id);
        param.setKey(paramKey);
        param.setValue(value);
        param.setWorkerIndex(workerIndex);
        LOG.info("listParam ({})", (Object)param);
        try {
            params = this.paramService.selectByPrimaryKeySelective(param);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(params).build();
    }

    @GET
    @Path(value="/{id}")
    @SubmarineApi
    public Response getParam(@PathParam(value="id") String id) {
        ParamEntity param;
        LOG.info("getParam ({})", (Object)id);
        try {
            param = this.paramService.selectById(id);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(param).build();
    }

    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response postParam(ParamEntity param) {
        boolean result;
        LOG.info("postParam ({})", (Object)param);
        try {
            result = this.paramService.insert(param);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response deleteParam(@QueryParam(value="id") String id) {
        boolean result;
        LOG.info("deleteParam ({})", (Object)id);
        try {
            result = this.paramService.deleteById(id);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response putParam(ParamEntity param) {
        LOG.info("putParam ({})", (Object)param);
        boolean result = false;
        try {
            result = this.paramService.update(param);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(result).build();
    }

    @POST
    @Path(value="/selective")
    @SubmarineApi
    public Response selectByPrimaryKeySelective(ParamEntity metric) {
        List<ParamEntity> params;
        try {
            params = this.paramService.selectByPrimaryKeySelective(metric);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(params).build();
    }
}

