/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest.workbench;

import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.apache.submarine.server.workbench.database.entity.SysDictItemEntity;
import org.apache.submarine.server.workbench.database.mappers.SysDictItemMapper;
import org.apache.submarine.server.workbench.database.service.SysDictItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sys/dictItem")
@Produces(value={"application/json"})
@Singleton
public class SysDictItemRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SysDictItemRestApi.class);
    private static final Gson gson = new Gson();

    @Inject
    public SysDictItemRestApi() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response list(@QueryParam(value="dictCode") String dictCode, @QueryParam(value="itemText") String itemText, @QueryParam(value="itemValue") String itemValue, @QueryParam(value="column") String column, @QueryParam(value="field") String field, @QueryParam(value="order") String order, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        LOG.info("queryList dictId:{}, itemText:{}, itemValue:{}, pageNo:{}, pageSize:{}", new Object[]{dictCode, itemText, itemValue, pageNo, pageSize});
        List<SysDictItemEntity> list = null;
        SqlSession sqlSession = MyBatisUtil.getSqlSession();
        SysDictItemMapper sysDictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
        try {
            HashMap<String, String> where = new HashMap<String, String>();
            where.put("dictCode", dictCode);
            where.put("itemText", itemText);
            where.put("itemValue", itemValue);
            list = sysDictItemMapper.selectAll(where, new RowBounds(pageNo, pageSize));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            Response response = new JsonResponse.Builder(Response.Status.OK).success(false).build();
            return response;
        }
        finally {
            sqlSession.close();
        }
        PageInfo page = new PageInfo(list);
        JsonResponse.ListResult<SysDictItemEntity> listResult = new JsonResponse.ListResult<SysDictItemEntity>(list, page.getTotal());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response add(SysDictItemEntity sysDictItem) {
        LOG.info("addDict sysDictItem:{}", (Object)sysDictItem.toString());
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictItemMapper sysDictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
            try {
                sysDictItemMapper.insertSysDictItem(sysDictItem);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Saving dictionary failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Save the dictionary successfully!").success(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response edit(SysDictItemEntity sysDictItem) {
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictItemMapper sysDictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
            try {
                SysDictItemEntity dictItem = sysDictItemMapper.getById(sysDictItem.getId());
                if (dictItem == null) {
                    Response response = new JsonResponse.Builder(Response.Status.OK).message("Can not found dict item:" + sysDictItem.getId()).success(false).build();
                    return response;
                }
                sysDictItemMapper.updateBy(sysDictItem);
                sqlSession.commit();
                return new JsonResponse.Builder(Response.Status.OK).message("Update the dictionary successfully!").success(true).build();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return new JsonResponse.Builder(Response.Status.OK).message("Update the dictionary successfully!").success(true).build();
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Update dictionary failed!").success(false).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response delete(@QueryParam(value="id") String id, @QueryParam(value="deleted") int deleted) {
        String msgOperation = "Delete";
        if (deleted == 0) {
            msgOperation = "Restore";
        }
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictItemMapper sysDictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
            try {
                SysDictItemEntity dictItem = new SysDictItemEntity();
                dictItem.setId(id);
                dictItem.setDeleted(deleted);
                sysDictItemMapper.updateBy(dictItem);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " dict item failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " the dict item successfully!").success(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/remove")
    @SubmarineApi
    public Response remove(String id) {
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictItemMapper sysDictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
            try {
                sysDictItemMapper.deleteById(id);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Delete dict item failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Delete the dict item successfully!").success(true).build();
    }

    @GET
    @Path(value="/getDictItems/{dictCode}")
    @SubmarineApi
    public Response getDictItems(@PathParam(value="dictCode") String dictCode) {
        LOG.info("dictCode : " + dictCode);
        SysDictItemService sysDictItemService = new SysDictItemService();
        List<SysDictItemEntity> dictItems = sysDictItemService.queryDictByCode(dictCode);
        JsonResponse.ListResult<SysDictItemEntity> listResult = new JsonResponse.ListResult<SysDictItemEntity>(dictItems, dictItems.size());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }
}

