/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest.workbench;

import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.apache.submarine.server.workbench.database.entity.SysUserEntity;
import org.apache.submarine.server.workbench.database.mappers.SystemMapper;
import org.apache.submarine.server.workbench.database.service.SysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sys")
@Produces(value={"application/json"})
@Singleton
public class SystemRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SystemRestApi.class);
    private SysUserService userService = new SysUserService();

    @Inject
    public SystemRestApi() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/duplicateCheck")
    @SubmarineApi
    public Response duplicateCheck(@QueryParam(value="tableName") String tableName, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldVal") String fieldVal, @QueryParam(value="equalFieldName") String equalFieldName, @QueryParam(value="equalFieldVal") String equalFieldVal, @QueryParam(value="dataId") String dataId) {
        LOG.info("tableName:{}, fieldName:{}, fieldVal:{}, equalFieldName:{}, equalFieldVal:{}, dataId:{}", new Object[]{tableName, fieldName, fieldVal, equalFieldName, equalFieldVal, dataId});
        SqlSession sqlSession = MyBatisUtil.getSqlSession();
        SystemMapper systemMapper = (SystemMapper)sqlSession.getMapper(SystemMapper.class);
        Long count = 0L;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tableName", tableName);
            params.put("fieldName", fieldName);
            params.put("fieldVal", fieldVal);
            params.put("equalFieldName", equalFieldName);
            params.put("equalFieldVal", equalFieldVal);
            params.put("dataId", dataId);
            count = systemMapper.duplicateCheck(params);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            sqlSession.close();
        }
        if (count == null || count == 0L) {
            LOG.info("This value is available");
            return new JsonResponse.Builder(Response.Status.OK).message("This value is available!").success(true).build();
        }
        LOG.info("This value already exists is not available!");
        return new JsonResponse.Builder(Response.Status.OK).message("This value already exists is not available!").success(false).build();
    }

    @GET
    @Path(value="/searchSelect/{tableName}")
    @SubmarineApi
    public Response searchSelect(@PathParam(value="tableName") String tableName, @QueryParam(value="keyword") String keyword) {
        if (StringUtils.equals((String)tableName, (String)"sys_user")) {
            List<SysUserEntity> list = null;
            try {
                list = this.userService.queryPageList(keyword, null, null, null, null, 1, 1000);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return new JsonResponse.Builder(Response.Status.OK).success(false).build();
            }
            PageInfo page = new PageInfo(list);
            JsonResponse.ListResult<SysUserEntity> listResult = new JsonResponse.ListResult<SysUserEntity>(list, page.getTotal());
            return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(false).build();
    }
}

