/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest.workbench;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.submarine.server.rest.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.utils.response.JsonResponse;
import org.apache.submarine.server.workbench.database.entity.TeamEntity;
import org.apache.submarine.server.workbench.database.service.TeamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/team")
@Produces(value={"application/json"})
@Singleton
public class TeamRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(TeamRestApi.class);
    private TeamService teamService = new TeamService();

    @Inject
    public TeamRestApi() {
    }

    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response list(@QueryParam(value="owner") String owner, @QueryParam(value="column") String column, @QueryParam(value="order") String order, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        LOG.info("TeamRestApi.list() owner:{}, pageNo:{}, pageSize:{}", new Object[]{owner, pageNo, pageSize});
        List<Object> teams = new ArrayList();
        try {
            teams = this.teamService.queryPageList(owner, column, order, pageNo, pageSize);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        PageInfo page = new PageInfo(teams);
        JsonResponse.ListResult listResult = new JsonResponse.ListResult(teams, page.getTotal());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }

    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response add(TeamEntity team) {
        LOG.info("add team:{}", (Object)team.toString());
        try {
            this.teamService.add(team);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Save team failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Save team successfully!").result(team).success(true).build();
    }

    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response edit(TeamEntity team) {
        LOG.info("edit team:{}", (Object)team.toString());
        try {
            this.teamService.updateByPrimaryKeySelective(team);
        }
        catch (Exception e) {
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Update team failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Update team successfully!").success(true).build();
    }

    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response delete(@QueryParam(value="id") String id) {
        LOG.info("delete team:{}", (Object)id);
        try {
            this.teamService.delete(id);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("delete team failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Delete team successfully!").success(true).build();
    }
}

