/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.s3;

import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;

public class Client {
    public MinioClient minioClient;

    public Client() {
        this.minioClient = MinioClient.builder().endpoint("http://submarine-minio-service:9000").credentials("submarine_minio", "submarine_minio").build();
    }

    public Client(String endpoint) {
        this.minioClient = MinioClient.builder().endpoint(endpoint).credentials("submarine_minio", "submarine_minio").build();
    }

    public List<String> listArtifact(String path) throws SubmarineRuntimeException {
        try {
            Iterable artifacts = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket("submarine")).prefix(path + "/").delimiter("/").build());
            ArrayList<String> response = new ArrayList<String>();
            for (Result artifact : artifacts) {
                response.add("s3://submarine/" + ((Item)artifact.get()).objectName());
            }
            return response;
        }
        catch (Exception e) {
            throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
        }
    }

    public void deleteArtifactsByExperiment(String experimentId) {
        this.deleteAllArtifactsByFolder(String.format("experiment/%s", experimentId));
    }

    public void deleteAllArtifacts() {
        this.deleteAllArtifactsByFolder("");
    }

    public void deleteArtifactsByModelVersion(String modelName, Integer version, String modelId) {
        String uniqueModelPath = String.format("%s-%d-%s", modelName, version, modelId);
        this.deleteAllArtifactsByFolder(String.format("registry/%s", uniqueModelPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] downloadArtifact(String path) {
        try (InputStream is = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket("submarine")).object(path)).build());){
            int b = is.read();
            if (b == -1) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] buffer = new byte[1 + is.available()];
            buffer[0] = (byte)b;
            int i = 1;
            while ((b = is.read()) != -1) {
                buffer[i] = (byte)b;
                ++i;
            }
            return buffer;
        }
        catch (Exception e) {
            throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
        }
    }

    public void copyArtifact(String targetPath, String sourcePath) {
        try {
            this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket("submarine")).object(targetPath)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket("submarine")).object(sourcePath)).build()).build());
        }
        catch (Exception e) {
            throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
        }
    }

    public void logArtifact(String path, byte[] content) throws SubmarineRuntimeException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(content);
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket("submarine")).object(path)).stream((InputStream)targetStream, (long)content.length, -1L).build());
        }
        catch (Exception e) {
            throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
        }
    }

    public List<String> listAllObjects(String path) throws SubmarineRuntimeException {
        ArrayList<String> result = new ArrayList<String>();
        Stack<String> dirs = new Stack<String>();
        dirs.add(path);
        while (!dirs.empty()) {
            String dir = (String)dirs.pop();
            try {
                Iterable artifacts = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket("submarine")).prefix(dir).delimiter("/").build());
                for (Result artifact : artifacts) {
                    String objectName = ((Item)artifact.get()).objectName();
                    if (objectName.endsWith("/")) {
                        dirs.add(objectName);
                        continue;
                    }
                    result.add(objectName);
                }
            }
            catch (Exception e) {
                throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            }
        }
        return result;
    }

    private void deleteAllArtifactsByFolder(String folder) {
        Iterable artifactNames = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket("submarine")).prefix(folder + "/").recursive(true).build());
        LinkedList<DeleteObject> objects = new LinkedList<DeleteObject>();
        for (Result artifactName : artifactNames) {
            try {
                objects.add(new DeleteObject(((Item)artifactName.get()).objectName()));
                Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket("submarine")).objects(objects).build());
                Iterator iterator = results.iterator();
                if (!iterator.hasNext()) continue;
                Result result = (Result)iterator.next();
                DeleteError error = (DeleteError)result.get();
                throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error in deleting object " + error.objectName() + "; " + error.message());
            }
            catch (Exception e) {
                throw new SubmarineRuntimeException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            }
        }
    }
}

