/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.MetricEntity;
import org.apache.submarine.server.workbench.database.mappers.MetricMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricService.class);

    public List<MetricEntity> selectAll() throws Exception {
        List<MetricEntity> result;
        LOG.info("Metric selectAll");
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            result = mapper.selectAll();
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return result;
    }

    public boolean deleteById(String id) throws Exception {
        LOG.info("Metric deleteByPrimaryKey {}", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            mapper.deleteById(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean insert(MetricEntity metric) throws Exception {
        LOG.info("Metric insert {}", (Object)metric);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            mapper.insert(metric);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public MetricEntity selectById(String id) throws Exception {
        MetricEntity metric;
        LOG.info("Metric selectByPrimaryKey {}", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            metric = mapper.selectById(id);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return metric;
    }

    public boolean update(MetricEntity metric) throws Exception {
        LOG.info("Metric update {}", (Object)metric);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            mapper.update(metric);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public List<MetricEntity> selectByPrimaryKeySelective(MetricEntity metric) throws Exception {
        List<MetricEntity> result;
        LOG.info("Metric selectByPrimaryKeySelective");
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            MetricMapper mapper = (MetricMapper)sqlSession.getMapper(MetricMapper.class);
            result = mapper.selectByPrimaryKeySelective(metric);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return result;
    }
}

