/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.ProjectEntity;
import org.apache.submarine.server.workbench.database.entity.ProjectFilesEntity;
import org.apache.submarine.server.workbench.database.mappers.ProjectFilesMapper;
import org.apache.submarine.server.workbench.database.mappers.ProjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectService.class);

    public List<ProjectEntity> queryPageList(String userName, String column, String order, int pageNo, int pageSize) throws Exception {
        LOG.info("queryPageList owner:{}, column:{}, order:{}, pageNo:{}, pageSize:{}", new Object[]{userName, column, order, pageNo, pageSize});
        List<ProjectEntity> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("userName", userName);
            where.put("column", column);
            where.put("order", order);
            list = projectMapper.selectAll(where, new RowBounds(pageNo, pageSize));
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            for (ProjectEntity project : list) {
                HashMap<String, Object> whereMember = new HashMap<String, Object>();
                whereMember.put("projectId", project.getId());
                List<ProjectFilesEntity> projectFilesList = projectFilesMapper.selectAll(whereMember);
                for (ProjectFilesEntity projectFiles : projectFilesList) {
                    project.addProjectFilesList(projectFiles);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public boolean add(ProjectEntity project) throws Exception {
        LOG.info("add({})", (Object)project.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.insert(project);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            List<ProjectFilesEntity> list = project.getProjectFilesList();
            for (ProjectFilesEntity projectFiles : list) {
                projectFiles.setProjectId(project.getId());
                projectFilesMapper.insert(projectFiles);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean updateByPrimaryKeySelective(ProjectEntity project) throws Exception {
        LOG.info("updateByPrimaryKeySelective({})", (Object)project.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.updateByPrimaryKeySelective(project);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("projectId", project.getId());
            List<ProjectFilesEntity> oldProjectFiles = projectFilesMapper.selectAll(where);
            ArrayList<String> oldProjectFilesId = new ArrayList<String>();
            for (ProjectFilesEntity oldProjectFile : oldProjectFiles) {
                oldProjectFilesId.add(oldProjectFile.getId());
            }
            List<ProjectFilesEntity> currProjectFiles = project.getProjectFilesList();
            ArrayList<String> currProjectFilesId = new ArrayList<String>();
            for (ProjectFilesEntity currProjectFile : currProjectFiles) {
                currProjectFilesId.add(currProjectFile.getId());
            }
            for (ProjectFilesEntity old : oldProjectFiles) {
                if (!currProjectFilesId.contains(old.getId())) {
                    projectFilesMapper.deleteByPrimaryKey(old.getId());
                    continue;
                }
                for (ProjectFilesEntity currProjectFile : currProjectFiles) {
                    if (currProjectFile.getId() == null || !currProjectFile.getId().equals(old.getId())) continue;
                    projectFilesMapper.updateByPrimaryKeySelective(currProjectFile);
                }
            }
            for (ProjectFilesEntity curr : currProjectFiles) {
                if (curr.getId() != null) continue;
                curr.setProjectId(project.getId());
                projectFilesMapper.insert(curr);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean delete(String id) throws Exception {
        LOG.info("delete({})", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.deleteByPrimaryKey(id);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            ProjectFilesEntity projectFiles = new ProjectFilesEntity();
            projectFiles.setProjectId(id);
            projectFilesMapper.deleteSelective(projectFiles);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }
}

