/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.rest.workbench.SysDictRestApi;
import org.apache.submarine.server.workbench.database.entity.SysDictItemEntity;
import org.apache.submarine.server.workbench.database.mappers.SysDictItemMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictItemService {
    private static final Logger LOG = LoggerFactory.getLogger(SysDictRestApi.class);

    public List<SysDictItemEntity> queryDictByCode(String dictCode) {
        List<SysDictItemEntity> dictItems = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDictItemMapper dictItemMapper = (SysDictItemMapper)sqlSession.getMapper(SysDictItemMapper.class);
            dictItems = dictItemMapper.queryDictByCode(dictCode);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return dictItems;
    }
}

