/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.database.utils.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.SysUserEntity;
import org.apache.submarine.server.workbench.database.mappers.SysUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysUserService {
    private static final Logger LOG = LoggerFactory.getLogger(SysUserService.class);
    private static String GET_USER_BY_NAME_STATEMENT = "org.apache.submarine.server.workbench.database.mappers.SysUserMapper.getUserByName";

    public SysUserEntity getUserByName(String name, String password) throws Exception {
        SysUserEntity sysUser = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            HashMap<String, String> mapParams = new HashMap<String, String>();
            mapParams.put("name", name);
            mapParams.put("password", password);
            HashMap<String, HashMap<String, String>> params = new HashMap<String, HashMap<String, String>>();
            params.put("mapParams", mapParams);
            sysUser = (SysUserEntity)sqlSession.selectOne(GET_USER_BY_NAME_STATEMENT, params);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return sysUser;
    }

    public SysUserEntity login(HashMap<String, String> mapParams) throws Exception {
        SysUserEntity sysUser = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper sysUserMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            sysUser = sysUserMapper.login(mapParams);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return sysUser;
    }

    public List<SysUserEntity> queryPageList(String userName, String email, String deptCode, String column, String field, int pageNo, int pageSize) throws Exception {
        LOG.info("SysUserService::queryPageList userName:{}, email:{}, deptCode:{}, column:{}, field:{}, pageNo:{}, pageSize:{}", new Object[]{userName, email, deptCode, column, field, pageNo, pageSize});
        List<SysUserEntity> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper sysUserMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("userName", userName);
            where.put("email", email);
            where.put("deptCode", deptCode);
            list = sysUserMapper.selectAll(where, new RowBounds(pageNo, pageSize));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public boolean add(SysUserEntity sysUser) throws Exception {
        LOG.info("add({})", (Object)sysUser.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper userMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            userMapper.add(sysUser);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean edit(SysUserEntity sysUser) throws Exception {
        LOG.info("edit({})", (Object)sysUser.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper userMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            userMapper.updateBy(sysUser);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean delete(String id) throws Exception {
        LOG.info("delete({})", (Object)id.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper userMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            userMapper.deleteById(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean changePassword(SysUserEntity user) throws Exception {
        LOG.info("changePassword({})", (Object)user.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysUserMapper userMapper = (SysUserMapper)sqlSession.getMapper(SysUserMapper.class);
            userMapper.changePassword(user);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }
}

