/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.submarine.server.workbench.database.entity.SysDeptEntity;
import org.apache.submarine.server.workbench.database.entity.SysDeptSelectEntity;
import org.apache.submarine.server.workbench.database.entity.SysDeptTree;

public class DepartmentUtil {
    public static void disableTargetDeptCode(List<SysDeptSelectEntity> sysDeptSelects, String deptCode) {
        if (sysDeptSelects == null) {
            return;
        }
        for (SysDeptSelectEntity deptSelect : sysDeptSelects) {
            if (deptSelect.getKey().equalsIgnoreCase(deptCode)) {
                deptSelect.setDisabled(true);
            }
            DepartmentUtil.disableTargetDeptCode(deptSelect.getChildren(), deptCode);
        }
    }

    public static List<SysDeptTree> wrapDeptListToTree(List<SysDeptEntity> sysDeptList, List<SysDeptSelectEntity> sysDeptSelects) {
        sysDeptSelects.clear();
        ArrayList<SysDeptTree> records = new ArrayList<SysDeptTree>();
        for (SysDeptEntity dept : sysDeptList) {
            records.add(new SysDeptTree(dept));
        }
        List<SysDeptTree> sysOrgTreeList = DepartmentUtil.findChildren(records, sysDeptSelects);
        DepartmentUtil.setEmptyChildrenAsNull(sysOrgTreeList);
        return sysOrgTreeList;
    }

    public static long getDeptTreeSize(List<SysDeptTree> sysDeptTreeList) {
        if (sysDeptTreeList == null) {
            return 0L;
        }
        long size = 0L;
        for (SysDeptTree sysDeptTree : sysDeptTreeList) {
            size += 1L + DepartmentUtil.getDeptTreeSize(sysDeptTree.getChildren());
        }
        return size;
    }

    private static List<SysDeptTree> findChildren(List<SysDeptTree> sysDeptList, List<SysDeptSelectEntity> sysDeptSelects) {
        ArrayList<SysDeptTree> treeList = new ArrayList<SysDeptTree>();
        for (SysDeptTree branch : sysDeptList) {
            if (!DepartmentUtil.isEmpty(branch.getParentCode())) continue;
            treeList.add(branch);
            SysDeptSelectEntity departIdModel = new SysDeptSelectEntity().convert(branch);
            sysDeptSelects.add(departIdModel);
        }
        DepartmentUtil.getGrandChildren(treeList, sysDeptList, sysDeptSelects);
        return treeList;
    }

    private static void getGrandChildren(List<SysDeptTree> treeList, List<SysDeptTree> recordList, List<SysDeptSelectEntity> sysDeptSelects) {
        for (int i = 0; i < treeList.size(); ++i) {
            SysDeptTree model = treeList.get(i);
            SysDeptSelectEntity idModel = sysDeptSelects.get(i);
            for (SysDeptTree m : recordList) {
                if (m.getParentCode() == null || !m.getParentCode().equals(model.getDeptCode())) continue;
                model.getChildren().add(m);
                SysDeptSelectEntity dim = new SysDeptSelectEntity().convert(m);
                idModel.getChildren().add(dim);
            }
            DepartmentUtil.getGrandChildren(treeList.get(i).getChildren(), recordList, sysDeptSelects.get(i).getChildren());
        }
    }

    private static void setEmptyChildrenAsNull(List<SysDeptTree> treeList) {
        for (SysDeptTree model : treeList) {
            if (model.getChildren().size() == 0) {
                model.setChildren(null);
                continue;
            }
            DepartmentUtil.setEmptyChildrenAsNull(model.getChildren());
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object)) {
            return true;
        }
        return "null".equals(object);
    }
}

