/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.utils;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.submarine.server.workbench.database.service.TeamService;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TeamService.class);

    public static void main(String[] args) {
        ArrayList warnings = new ArrayList();
        boolean overwrite = true;
        String genCfg = "/mbgConfiguration.xml";
        File configFile = new File(MybatisGenerator.class.getResource(genCfg).getFile());
        ConfigurationParser cp = new ConfigurationParser(warnings);
        Configuration config = null;
        try {
            config = cp.parseConfiguration(configFile);
        }
        catch (IOException | XMLParserException e) {
            LOG.error(e.getMessage(), e);
        }
        DefaultShellCallback callback = new DefaultShellCallback(overwrite);
        MyBatisGenerator myBatisGenerator = null;
        try {
            assert (config != null);
            myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
        }
        catch (InvalidConfigurationException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            assert (myBatisGenerator != null);
            myBatisGenerator.generate(null);
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

