/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.HomePage;
import org.apache.syncope.client.enduser.resources.LoginResource;
import org.apache.syncope.client.enduser.resources.LogoutResource;
import org.apache.syncope.client.enduser.resources.SchemaResource;
import org.apache.syncope.client.enduser.resources.SecurityQuestionResource;
import org.apache.syncope.client.enduser.resources.UserSelfCreateResource;
import org.apache.syncope.client.enduser.resources.UserSelfReadResource;
import org.apache.syncope.client.enduser.resources.UserSelfUpdateResource;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.springframework.util.Assert;

public class SyncopeEnduserApplication
extends WebApplication
implements Serializable {
    private static final long serialVersionUID = -6445919351044845120L;
    private static final String ENDUSER_PROPERTIES = "enduser.properties";
    public static final List<Locale> SUPPORTED_LOCALES = Collections.unmodifiableList(Arrays.asList(Locale.ENGLISH, Locale.ITALIAN, new Locale("pt", "BR")));
    private String version;
    private String site;
    private String license;
    private String anonymousUser;
    private String anonymousKey;
    private SyncopeClientFactoryBean clientFactory;

    public static SyncopeEnduserApplication get() {
        return (SyncopeEnduserApplication)WebApplication.get();
    }

    protected void init() {
        super.init();
        Properties props = new Properties();
        try {
            File enduserDirProps;
            props.load(this.getClass().getResourceAsStream("/enduser.properties"));
            File enduserDir = new File(props.getProperty("enduser.directory"));
            if (enduserDir.exists() && enduserDir.canRead() && enduserDir.isDirectory() && (enduserDirProps = FileUtils.getFile((File)enduserDir, (String[])new String[]{ENDUSER_PROPERTIES})).exists() && enduserDirProps.canRead() && enduserDirProps.isFile()) {
                props.clear();
                props.load(FileUtils.openInputStream((File)enduserDirProps));
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not read enduser.properties", (Throwable)e);
        }
        this.version = props.getProperty("version");
        Assert.notNull((Object)this.version, (String)"<version> not set");
        this.site = props.getProperty("site");
        Assert.notNull((Object)this.site, (String)"<site> not set");
        this.license = props.getProperty("license");
        Assert.notNull((Object)this.license, (String)"<license> not set");
        this.anonymousUser = props.getProperty("anonymousUser");
        Assert.notNull((Object)this.anonymousUser, (String)"<anonymousUser> not set");
        this.anonymousKey = props.getProperty("anonymousKey");
        Assert.notNull((Object)this.anonymousKey, (String)"<anonymousKey> not set");
        String scheme = props.getProperty("scheme");
        Assert.notNull((Object)scheme, (String)"<scheme> not set");
        String host = props.getProperty("host");
        Assert.notNull((Object)host, (String)"<host> not set");
        String port = props.getProperty("port");
        Assert.notNull((Object)port, (String)"<port> not set");
        String rootPath = props.getProperty("rootPath");
        Assert.notNull((Object)rootPath, (String)"<rootPath> not set");
        this.clientFactory = new SyncopeClientFactoryBean().setAddress(scheme + "://" + host + ":" + port + "/" + rootPath);
        this.clientFactory.setContentType(SyncopeClientFactoryBean.ContentType.JSON);
        this.mountResource("/api/login", new ResourceReference("login"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new LoginResource();
            }
        });
        this.mountResource("/api/logout", new ResourceReference("logout"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new LogoutResource();
            }
        });
        this.mountResource("/api/self/read", new ResourceReference("userSelfRead"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfReadResource();
            }
        });
        this.mountResource("/api/self/create", new ResourceReference("userSelfCreate"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfCreateResource();
            }
        });
        this.mountResource("/api/self/update", new ResourceReference("userSelfUpdate"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new UserSelfUpdateResource();
            }
        });
        this.mountResource("/api/schemas", new ResourceReference("schemas"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new SchemaResource();
            }
        });
        this.mountResource("/api/securityQuestions", new ResourceReference("securityQuestions"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new SecurityQuestionResource();
            }
        });
    }

    public Class<? extends Page> getHomePage() {
        return HomePage.class;
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeEnduserSession(request);
    }

    public String getVersion() {
        return this.version;
    }

    public String getSite() {
        return this.site;
    }

    public String getLicense() {
        return this.license;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public SyncopeClientFactoryBean getClientFactory() {
        return this.clientFactory;
    }
}

