/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.to.SyncopeTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeEnduserSession
extends WebSession {
    private static final long serialVersionUID = 1284946129513378647L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserSession.class);
    private final SyncopeClient anonymousClient;
    private SyncopeClient client;
    private String username;
    private String password;
    private final SyncopeTO syncopeTO;
    private UserTO selfTO;
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());

    public static SyncopeEnduserSession get() {
        return (SyncopeEnduserSession)Session.get();
    }

    public SyncopeEnduserSession(Request request) {
        super(request);
        this.anonymousClient = SyncopeEnduserApplication.get().getClientFactory().create(SyncopeEnduserApplication.get().getAnonymousUser(), SyncopeEnduserApplication.get().getAnonymousKey());
        this.syncopeTO = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).info();
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        try {
            this.client = SyncopeEnduserApplication.get().getClientFactory().setDomain("Master").create(username, password);
            Pair self = this.client.self();
            this.selfTO = (UserTO)self.getValue();
            this.username = username;
            this.password = password;
            this.bind();
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    private <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client == null ? this.anonymousClient.getService(serviceClass) : this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.getCachedService(serviceClass);
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getCachedService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false).type("application/json").accept(new String[]{"application/json"});
        return serviceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(MediaType mediaType, Class<T> serviceClass) {
        Object service;
        SyncopeClientFactoryBean syncopeClientFactoryBean = SyncopeEnduserApplication.get().getClientFactory();
        synchronized (syncopeClientFactoryBean) {
            SyncopeClientFactoryBean.ContentType preType = SyncopeEnduserApplication.get().getClientFactory().getContentType();
            SyncopeEnduserApplication.get().getClientFactory().setContentType(SyncopeClientFactoryBean.ContentType.fromString((String)mediaType.toString()));
            service = SyncopeEnduserApplication.get().getClientFactory().create(this.username, this.password).getService(serviceClass);
            SyncopeEnduserApplication.get().getClientFactory().setContentType(preType);
        }
        return (T)service;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SyncopeTO getSyncopeTO() {
        return this.syncopeTO;
    }

    public UserTO getSelfTO() {
        return this.selfTO;
    }

    public boolean isAuthenticated() {
        return this.getUsername() != null;
    }

    public DateFormat getDateFormat() {
        Locale locale = this.getLocale() == null ? Locale.ENGLISH : this.getLocale();
        return DateFormat.getDateTimeInstance(3, 3, locale);
    }
}

