/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.adapters;

import org.apache.syncope.client.enduser.model.UserTORequest;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTOAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(UserTOAdapter.class);

    public UserTO fromUserTORequest(UserTORequest userTORequest, String oldSelfPassword) {
        UserTO userTO = new UserTO();
        Long key = userTORequest.getKey();
        if (key != null) {
            userTO.setKey(key.longValue());
        }
        userTO.setUsername(userTORequest.getUsername());
        String requestPassword = userTORequest.getPassword();
        if (requestPassword == null || requestPassword.isEmpty()) {
            userTO.setPassword(oldSelfPassword == null ? null : oldSelfPassword);
        } else {
            userTO.setPassword(requestPassword);
        }
        userTO.setSecurityQuestion(userTORequest.getSecurityQuestion());
        userTO.setSecurityAnswer(userTORequest.getSecurityAnswer());
        userTO.setRealm(userTORequest.getRealm());
        userTO.getPlainAttrs().addAll(userTORequest.getPlainAttrs().values());
        userTO.getDerAttrs().addAll(userTORequest.getDerAttrs().values());
        userTO.getVirAttrs().addAll(userTORequest.getVirAttrs().values());
        return userTO;
    }

    public UserTORequest toUserTORequest(UserTO userTO) {
        UserTORequest userTORequest = new UserTORequest().key(userTO.getKey()).username(userTO.getUsername()).securityQuestion(userTO.getSecurityQuestion()).securityAnswer(userTO.getSecurityAnswer()).realm(userTO.getRealm());
        userTORequest.getPlainAttrs().putAll(userTO.getPlainAttrMap());
        userTORequest.getDerAttrs().putAll(userTO.getDerAttrMap());
        userTORequest.getVirAttrs().putAll(userTO.getVirAttrMap());
        return userTORequest;
    }
}

