/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.model.Credentials;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.core.misc.serialization.POJOHelper;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -7720997467070461915L;
    private static final Logger LOG = LoggerFactory.getLogger(LoginResource.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        int responseStatus;
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            String responseMessage;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            Credentials credentials = (Credentials)POJOHelper.deserialize((String)IOUtils.toString((InputStream)request.getInputStream()), Credentials.class);
            String username = credentials.getUsername();
            String password = credentials.getPassword().isEmpty() ? null : credentials.getPassword();
            LOG.debug("Enduser login, user: {}", (Object)username);
            if (StringUtils.isBlank((CharSequence)username)) {
                responseMessage = "Could not read credentials from request: username is blank!";
                LOG.error(responseMessage);
                responseStatus = 400;
            } else {
                boolean authenticated = SyncopeEnduserSession.get().authenticate(username, password);
                responseStatus = authenticated ? 200 : 401;
                responseMessage = username;
            }
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
        }
        catch (Exception e) {
            responseStatus = 400;
            LOG.error("Could not read credentials from request", (Throwable)e);
        }
        response.setStatusCode(Integer.valueOf(responseStatus));
        return response;
    }
}

