/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.model.SchemaResponse;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.syncope.core.misc.serialization.POJOHelper;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResource
extends AbstractBaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaResource.class);
    private static final long serialVersionUID = 6453101466981543020L;
    private final AnyTypeService anyTypeService = SyncopeEnduserSession.get().getService(AnyTypeService.class);
    private final SchemaService schemaService = SyncopeEnduserSession.get().getService(SchemaService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all {} any type kind related schemas", (Object)AnyTypeKind.USER.name());
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        int responseStatus = 200;
        try {
            AnyTypeTO anyTypeUserTO = this.anyTypeService.read(AnyTypeKind.USER.name());
            final List plainSchemas = this.schemaService.list(SchemaType.PLAIN, new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses((Collection)anyTypeUserTO.getClasses()).build());
            final List derSchemas = this.schemaService.list(SchemaType.DERIVED, new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses((Collection)anyTypeUserTO.getClasses()).build());
            final List virSchemas = this.schemaService.list(SchemaType.VIRTUAL, new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses((Collection)anyTypeUserTO.getClasses()).build());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)POJOHelper.serialize((Object)new SchemaResponse().plainSchemas(plainSchemas).derSchemas(derSchemas).virSchemas(virSchemas)));
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error retrieving {} any type kind related schemas", (Object)AnyTypeKind.USER.name(), (Object)e);
            responseStatus = 400;
        }
        response.setStatusCode(Integer.valueOf(responseStatus));
        return response;
    }

    private <T extends AbstractSchemaTO> List<T> getSchemaTOs(List<String> schemaNames, SchemaType schemaType, Class<T> type) {
        ArrayList<T> schemaTOs = new ArrayList<T>();
        for (String schemaName : schemaNames) {
            schemaTOs.add(type.cast(this.schemaService.read(schemaType, schemaName)));
        }
        return schemaTOs;
    }
}

