/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.adapters.UserTOAdapter;
import org.apache.syncope.client.enduser.model.UserTORequest;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.syncope.core.misc.serialization.POJOHelper;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSelfCreateResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSelfCreateResource.class);
    private final UserSelfService userSelfService;
    private final UserTOAdapter userTOAdapter = new UserTOAdapter();

    public UserSelfCreateResource() {
        this.userSelfService = SyncopeEnduserSession.get().getService(UserSelfService.class);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        int responseStatus = 200;
        final StringBuilder responseMessage = new StringBuilder();
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            UserTORequest userTORequest = (UserTORequest)POJOHelper.deserialize((String)IOUtils.toString((InputStream)request.getInputStream()), UserTORequest.class);
            if (this.isSelfRegistrationAllowed() && userTORequest != null) {
                LOG.debug("Received user self registration request for user: [{}]", (Object)userTORequest.getUsername());
                LOG.trace("Received user self registration request is: [{}]", (Object)userTORequest);
                this.userSelfService.create(this.userTOAdapter.fromUserTORequest(userTORequest, null), true);
                responseMessage.append("User").append(userTORequest.getUsername()).append("created successfully");
            } else {
                responseMessage.append(userTORequest == null ? "Request received is not valid" : "Self registration not allowed");
                responseStatus = 403;
            }
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not read userTO from request", (Throwable)e);
            responseStatus = 400;
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)e.getMessage());
                }
            });
        }
        response.setStatusCode(Integer.valueOf(responseStatus));
        return response;
    }
}

