/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.adapters.UserTOAdapter;
import org.apache.syncope.client.enduser.model.UserTORequest;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.syncope.core.misc.serialization.POJOHelper;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSelfUpdateResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSelfUpdateResource.class);
    private final UserSelfService userSelfService;
    private final UserTOAdapter userTOAdapter = new UserTOAdapter();

    public UserSelfUpdateResource() {
        this.userSelfService = SyncopeEnduserSession.get().getService(UserSelfService.class);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        int responseStatus;
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            UserTORequest userTOResponse = (UserTORequest)POJOHelper.deserialize((String)IOUtils.toString((InputStream)request.getInputStream()), UserTORequest.class);
            LOG.trace("userTOResponse: {}", (Object)userTOResponse);
            UserTO userTO = this.userTOAdapter.fromUserTORequest(userTOResponse, SyncopeEnduserSession.get().getPassword());
            LOG.debug("User {} id updating himself", (Object)userTO.getUsername());
            Response res = this.userSelfService.update(userTO);
            responseStatus = res.getStatus();
            final String responseMessage = "User updated successfully";
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            responseStatus = 400;
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)e.getMessage());
                }
            });
        }
        response.setStatusCode(Integer.valueOf(responseStatus));
        return response;
    }
}

