/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.model.SchemaResponse;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResource
extends AbstractBaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaResource.class);
    private static final long serialVersionUID = 6453101466981543020L;
    private final AnyTypeService anyTypeService = SyncopeEnduserSession.get().getService(AnyTypeService.class);
    private final SchemaService schemaService = SyncopeEnduserSession.get().getService(SchemaService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all {} any type kind related schemas", (Object)AnyTypeKind.USER.name());
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            AnyTypeTO anyTypeUserTO = this.anyTypeService.read(AnyTypeKind.USER.name());
            List<String> classes = new ArrayList<String>();
            String parameter = attributes.getParameters().get("anyTypeClass").toString();
            if (parameter != null) {
                classes.add(parameter);
            } else {
                classes = anyTypeUserTO.getClasses();
            }
            final List plainSchemas = this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.PLAIN).anyTypeClasses(classes).build());
            final List derSchemas = this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.DERIVED).anyTypeClasses(classes).build());
            final List virSchemas = this.schemaService.list(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).anyTypeClasses(classes).build());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)AbstractBaseResource.MAPPER.writeValueAsString((Object)new SchemaResponse().plainSchemas(plainSchemas).derSchemas(derSchemas).virSchemas(virSchemas)));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving {} any type kind related schemas", (Object)AnyTypeKind.USER.name(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

