/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.resources.AbstractBaseResource;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSelfUpdateResource
extends AbstractBaseResource {
    private static final long serialVersionUID = -2721621682300247583L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSelfUpdateResource.class);
    private final UserSelfService userSelfService = SyncopeEnduserSession.get().getService(UserSelfService.class);

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            String jsonString = request.getReader().readLine();
            UserTO userTO = (UserTO)MAPPER.readValue(jsonString, UserTO.class);
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha").toString())) {
                LOG.error("Entered captcha is not matching");
                throw new Exception("Entered captcha is not matching");
            }
            LOG.debug("User {} id updating himself", (Object)userTO.getUsername());
            Response res = this.userSelfService.update(userTO);
            final String responseMessage = res.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) ? "User" + userTO.getUsername() + " successfully updated" : "ErrorMessage{{ " + res.getStatusInfo().getReasonPhrase() + " }}";
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)responseMessage);
                }
            });
            response.setStatusCode(Integer.valueOf(res.getStatus()));
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

